package com.instabug.library.sessionreplay.model

import androidx.annotation.StringDef
import com.instabug.library.sessionreplay.model.SessionMetadata.LaunchType.Companion.COLD
import com.instabug.library.sessionreplay.model.SessionMetadata.LaunchType.Companion.HOT
import com.instabug.library.sessionreplay.model.SessionMetadata.LaunchType.Companion.WARM

class SessionMetadata private constructor(builder: Builder) {

    val device = builder.device
    val os = builder.os
    val appVersion = builder.appVersion
    val sessionDurationInSeconds = builder.sessionDurationInSeconds
    val networkLogs = builder.networkLogs
    var linkedToReview: Boolean = builder.linkedToReview
    val launchType = builder.launchType
    val launchDuration = builder.launchDuration

    class Builder(
        var device: String,
        var os: String,
        var appVersion: String,
        var sessionDurationInSeconds: Long,
        var linkedToReview: Boolean,
        @LaunchType var launchType: String? = null,
        var launchDuration: Long? = null,
        var networkLogs: List<NetworkLog>? = null
    ) {

        fun build(): SessionMetadata =
            SessionMetadata(this)
    }

    @Target(
        AnnotationTarget.PROPERTY, AnnotationTarget.VALUE_PARAMETER,
        AnnotationTarget.TYPE, AnnotationTarget.LOCAL_VARIABLE
    )
    @StringDef(
        COLD,
        WARM,
        HOT
    )
    annotation class LaunchType {
        companion object {
            const val COLD = "Cold"
            const val WARM = "Warm"
            const val HOT = "Hot"
        }
    }

    data class NetworkLog(val url: String?, val duration: Long, val statusCode: Int)
}
