package com.instabug.library.networkv2.utils

import com.instabug.library.BuildConfig
import com.instabug.library.Instabug
import com.instabug.library.R
import org.json.JSONObject
import java.nio.charset.Charset

object IBGDomainProvider {

    private const val INSTABUG_DOMAIN_KEY = "instabug-domain"
    private const val APM_DOMAIN_KEY = "apm-domain"
    private lateinit var instabugDomain: String
    private lateinit var apmDomain: String

    init {
        val configJson = getEndPointsConfig()
        val instabugDomain = configJson?.takeIf { it.has(INSTABUG_DOMAIN_KEY) }
            ?.getString(INSTABUG_DOMAIN_KEY)
            ?.takeIf { it.isNotBlank() }
        instabugDomain?.let { IBGDomainProvider.instabugDomain = it }

        val apmDomain = configJson?.takeIf { it.has(APM_DOMAIN_KEY) }
            ?.getString(APM_DOMAIN_KEY)
            ?.takeIf { it.isNotBlank() }
        apmDomain?.let { IBGDomainProvider.apmDomain = it }
    }

    @JvmStatic
    fun getInstabugDomain(): String {
        return if (this::instabugDomain.isInitialized) {
            return instabugDomain
        } else {
            BuildConfig.DOMAIN
        }
    }

    @JvmStatic
    fun getAPMDomain(): String {
        return if (this::apmDomain.isInitialized) {
            return apmDomain
        } else {
            BuildConfig.DOMAIN_APM
        }
    }

    @JvmStatic
    fun getDiagnosticsDomain(): String {
        return BuildConfig.DIAGNOSIS_DOMAIN
    }


    private fun getEndPointsConfig(): JSONObject? = kotlin.runCatching {
        return Instabug.getApplicationContext()
            ?.resources
            ?.openRawResource(R.raw.instabug_config)
            ?.reader(Charset.forName("UTF-8"))
            ?.readLines()
            ?.joinToString("")
            ?.toJson()
    }.getOrNull()

    private fun String.toJson(): JSONObject? {
        return kotlin.runCatching { JSONObject(this) }.getOrNull()
    }
}