package com.instabug.library.networkv2.detectors;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;

import com.instabug.library.Constants;
import com.instabug.library.Instabug;
import com.instabug.library.core.eventbus.coreeventbus.IBGCoreEventPublisher;
import com.instabug.library.core.eventbus.coreeventbus.IBGSdkCoreEvent;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;

/**
 * Broadcast receiver used to detect a change in connectivity of the phone
 * and start uploading bugs in the cache if the phone comes online
 */
public class IBGNetworkReceiver extends BroadcastReceiver {

    private boolean registered;

    @Override
    public void onReceive(final Context context, Intent intent) {
        PoolProvider.postIOTask(() -> {
            InstabugSDKLogger.v(Constants.LOG_TAG, "Network state changed");
            if (context != null) {
                ConnectivityManager cm = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
                if (cm != null) {
                    NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
                    if (activeNetwork != null && Instabug.isEnabled()) {
                        PoolProvider.postIOTask(() ->
                                IBGCoreEventPublisher.post(IBGSdkCoreEvent.NetworkActivated.INSTANCE)
                        );
                    }
                }
            } else {
                InstabugSDKLogger.e(Constants.LOG_TAG, "Context was null while checking for network info");
            }
        });
    }

    public void register(Context context, IntentFilter filter) {
        context.registerReceiver(this, filter);
        registered = true;
    }

    public void unregister(Context context) {
        context.unregisterReceiver(this);
        registered = false;
    }

    public boolean isRegistered() {
        return registered;
    }
}
