package com.instabug.library.networkv2.authorization.ispx

import com.instabug.library.internal.sdkexperiments.ImplementationFactory
import com.instabug.library.internal.sdkexperiments.PercentageSDKExperiment

private const val EXPERIMENT_CONFIG_KEY = "exp_an_jsa_enabled"
private const val EXPERIMENT_PREF_KEY = "exp_java_generative_signing"

class ISPImplementationFactory : ImplementationFactory<ISP> {
    override fun createLegacy(): ISP = LSP()

    override fun createExperimental(): ISP = ESP()
}

class ISPSDKExperiment : PercentageSDKExperiment<ISP>(
    EXPERIMENT_PREF_KEY,
    EXPERIMENT_CONFIG_KEY,
    ISPImplementationFactory()
)
