package com.instabug.library.model

import org.json.JSONArray
import org.json.JSONObject
import java.text.SimpleDateFormat
import java.util.Calendar
import java.util.Locale

object ConsoleLogsMapper {
    private const val CONSOLE_LOG_DEFAULT_DATE_FORMAT = "MM-dd HH:mm:ss.SSS"
    private const val KEY_TIMESTAMP = "timestamp"
    private const val KEY_MESSAGE = "message"
    private const val KEY_DATE = "date"

    @JvmStatic
    fun updateLogs(consoleLogs: JSONArray) {
        val formatter = SimpleDateFormat(CONSOLE_LOG_DEFAULT_DATE_FORMAT, Locale.US)
        val temCalender = Calendar.getInstance()
        val stampCalender = Calendar.getInstance()
        for (i in 0 until consoleLogs.length()) {
            consoleLogs.get(i).toString()
                .let { logString ->
                    updateLogJsonObject(logString, formatter, temCalender, stampCalender)
                }.also { logObject ->
                    consoleLogs.put(i, logObject)
                }
        }
    }

    private fun updateLogJsonObject(
        logString: String,
        formatter: SimpleDateFormat,
        temCalender: Calendar?,
        stampCalender: Calendar?
    ) : JSONObject {
        return logString.extractConsoleLogData(formatter, temCalender, stampCalender)
    }

    private fun String.extractConsoleLogData(
        formatter: SimpleDateFormat,
        temCalender: Calendar?,
        stampCalender: Calendar?,
    ): JSONObject {
        val logJsonObject = JSONObject()
        val message = subSequence(startIndex = 18, length)
        val date = subSequence(0, 18)
        val timeStamp = ConsoleLog.convertConsoleLogMessageDateToTimeStamp(
            date.toString(),
            formatter,
            temCalender,
            stampCalender
        )
        logJsonObject.put(KEY_MESSAGE, message)
        logJsonObject.put(KEY_DATE, date)
        return logJsonObject.put(KEY_TIMESTAMP, timeStamp)
    }
}