package com.instabug.library.migration;

import android.content.Context;

import com.instabug.library.settings.SettingsManager;

import androidx.annotation.NonNull;
import io.reactivexport.Observable;
import io.reactivexport.ObservableEmitter;
import io.reactivexport.ObservableOnSubscribe;

/**
 * Created by Tarek360 on 1/11/17.
 */
public class LastContactedAtToLastBugAndLastChatTimeMigration extends AbstractMigration {

    private static final String MIGRATION_ID = "last_contacted_at_to_last_bug_and_last_chat_time_migration";

    public LastContactedAtToLastBugAndLastChatTimeMigration() {
        super(MIGRATION_ID);
    }

    @Override
    public String getMigrationId() {
        return MIGRATION_ID;
    }

    @Override
    public int getMigrationVersion() {
        return 3;
    }

    @Override
    public void initialize(@NonNull Context context) {

    }

    @Override
    public boolean shouldMigrate() {
        return getMigrationVersion() > SettingsManager.getInstance().getLastMigrationVersion()
                && (SettingsManager.getInstance().getLastContactedAt() != 0L);
    }

    @Override
    public Observable<AbstractMigration> migrate() {

        return Observable.create(new ObservableOnSubscribe<AbstractMigration>() {
            @Override
            public void subscribe(ObservableEmitter<AbstractMigration> emitter) {
                emitter.onNext(LastContactedAtToLastBugAndLastChatTimeMigration.this);
                emitter.onComplete();
            }
        });
    }

    @Override
    public void doPreMigration() {

    }

    @Override
    public void doAfterMigration() {

    }

}
