package com.instabug.library.migration;

import android.content.Context;

import androidx.annotation.NonNull;
import io.reactivexport.Observable;

/**
 * Created by mesbah on 12/16/2015.
 */
public abstract class AbstractMigration {

    private String migrationId;

    public AbstractMigration(String migrationId) {
        this.migrationId = migrationId;
    }

    public String getMigrationId() {
        return migrationId;
    }

    public abstract int getMigrationVersion();

    public abstract void initialize(@NonNull final Context context);

    public abstract boolean shouldMigrate();

    public abstract Observable<AbstractMigration> migrate();

    public abstract void doPreMigration();

    public abstract void doAfterMigration();

}
