package com.instabug.library.invocation;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

import androidx.annotation.IntDef;


@Retention(RetentionPolicy.SOURCE)
@IntDef({InvocationMode.PROMPT_OPTIONS,
        InvocationMode.NEW_BUG,
        InvocationMode.NEW_FEEDBACK,
        InvocationMode.ASK_QUESTION,
        InvocationMode.CHATS,
        InvocationMode.UNDEFINED
})
public @interface InvocationMode {
    int PROMPT_OPTIONS = 0;
    int NEW_BUG = 1;
    int NEW_FEEDBACK = 2;
    int ASK_QUESTION = 3;
    int CHATS = 4;
    int UNDEFINED = -1;
}
