package com.instabug.library.internal.storage.operation;

import android.net.Uri;

import androidx.annotation.Nullable;

import com.instabug.library.Constants;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;

import java.io.File;

public class DeleteUriDiskOperation implements DiskOperation<Boolean, Void> {

    private final Uri uri;

    public DeleteUriDiskOperation(Uri uri) {this.uri = uri;}

    @Override
    public synchronized Boolean execute(@Nullable Void aVoid) {
        try {
            return delete();
        } catch (Exception e) {
            InstabugSDKLogger.e(Constants.LOG_TAG, "Error while deleting ANR state file", e);
            return false;
        }
    }

    @Override
    public void executeAsync(@Nullable Void aVoid, @Nullable final DiskOperationCallback<Boolean> callback) {
        PoolProvider.postIOTask(new Runnable() {
            @Override
            public void run() {
                try {
                    boolean deleted = delete();
                    if (callback != null) {
                        callback.onSuccess(deleted);
                    }
                } catch (Throwable e) {
                    if (callback != null) {
                        callback.onFailure(e);
                    }
                }
            }
        });
    }

    private boolean delete() throws Exception{
        return uri != null && uri.getPath() != null && new File(uri.getPath()).delete();
    }
}
