package com.instabug.library.internal.storage.cache.dbv2.migration

import android.database.sqlite.SQLiteDatabase
import com.instabug.library.internal.storage.cache.dbv2.IBGDbContract
import com.instabug.library.internal.storage.cache.dbv2.IBGEncryptedDbVersions

class DBMigrationV17(override val db:SQLiteDatabase): BaseDBMigrationImpl(db) {
    override val previous: BaseDbMigration? by lazy { DBMigrationV16(db) }
    override val version: Int
        get() = IBGEncryptedDbVersions.DB_V17


    override fun execute() {
        runLogic {
            db.execSQL(
                "ALTER TABLE ${IBGDbContract.BugEntry.TABLE_NAME} ADD COLUMN ${IBGDbContract.BugEntry.COLUMN_FRUSTRATING_EXPERIENCE_INTERNAL_ID}"
                        + "${IBGDbContract.INTEGER_TYPE} DEFAULT 0"
            )

            db.execSQL(
                "ALTER TABLE ${IBGDbContract.BugEntry.TABLE_NAME} ADD COLUMN ${IBGDbContract.BugEntry.COLUMN_FRUSTRATING_EXPERIENCE_EXTERNAL_ID}"
                        + "${IBGDbContract.TEXT_TYPE} DEFAULT NULL"
            )
        }
    }
}