package com.instabug.library.internal.storage.cache.dbv2.migration

import android.database.sqlite.SQLiteDatabase
import com.instabug.library.internal.storage.cache.dbv2.IBGDbContract
import com.instabug.library.internal.storage.cache.dbv2.IBGEncryptedDbVersions

class DBMigrationV13(override val db: SQLiteDatabase) : BaseDBMigrationImpl(db) {
    override val previous: BaseDbMigration by lazy { DBMigrationV12(db) }

    override val version: Int
        get() = IBGEncryptedDbVersions.DB_V13

    override fun execute() =
        runLogic {
            db.execSQL(
                "ALTER TABLE ${IBGDbContract.SessionEntry.TABLE_NAME} " +
                        "ADD COLUMN ${IBGDbContract.SessionEntry.COLUMN_SR_ENABLED} ${IBGDbContract.INTEGER_TYPE} DEFAULT 1"
            )
        }
}