package com.instabug.library.internal.storage.cache.dbv2.migration

import android.database.sqlite.SQLiteDatabase
import com.instabug.library.internal.storage.cache.dbv2.IBGDbContract
import com.instabug.library.internal.storage.cache.dbv2.IBGDbContract.TEXT_TYPE
import com.instabug.library.internal.storage.cache.dbv2.IBGEncryptedDbVersions.DB_V11

class DBMigrationV11(override val db: SQLiteDatabase) : BaseDBMigrationImpl(db) {

    override val previous: BaseDbMigration by lazy { DBMigrationV10(db) }

    override val version: Int
        get() = DB_V11

    override fun execute() = runLogic {
        with(db) {
            execSQL(
                "Alter Table ${IBGDbContract.SessionEntry.TABLE_NAME} " +
                        "ADD COLUMN  ${IBGDbContract.SessionEntry.COLUMN_SESSION_RANDOM_ID} ${IBGDbContract.INTEGER_TYPE} DEFAULT -1 "
            )
            execSQL(
                "ALTER TABLE ${IBGDbContract.SessionEntry.TABLE_NAME} " +
                        "ADD COLUMN  ${IBGDbContract.SessionEntry.COLUMN_LOCALE} $TEXT_TYPE DEFAULT NULL "
            )
            execSQL(
                "ALTER TABLE ${IBGDbContract.SessionEntry.TABLE_NAME} " +
                        "ADD COLUMN  ${IBGDbContract.SessionEntry.COLUMN_SCREEN_SIZE} $TEXT_TYPE DEFAULT NULL "
            )
        }
    }
}
