package com.instabug.library.internal.storage.cache.dbv2.migration

import android.database.sqlite.SQLiteDatabase
import com.instabug.library.internal.storage.cache.dbv2.IBGDbContract.SessionEntry
import com.instabug.library.internal.storage.cache.dbv2.IBGDbContract.TEXT_TYPE
import com.instabug.library.internal.storage.cache.dbv2.IBGEncryptedDbVersions

class DBMigrationV10(override val db: SQLiteDatabase) : BaseDBMigrationImpl(db) {

    override val previous: BaseDbMigration by lazy { DBMigrationV9(db) }

    override val version: Int
        get() = IBGEncryptedDbVersions.DB_V10

    override fun execute() {
        addRatingDialogDetectionColumnToV3SessionTable()
    }

    private fun addRatingDialogDetectionColumnToV3SessionTable() =
        db.execSQL("ALTER TABLE ${SessionEntry.TABLE_NAME} ADD COLUMN ${SessionEntry.COLUMN_RATING_DIALOG_DETECTION} $TEXT_TYPE DEFAULT NULL")
}
