package com.instabug.library.internal.storage.cache.dbv2;

public class IBGEncryptedDbVersions {
    /*
     * First version of encrypted database, contains non-fatals and occurrences tables
     */
    public static final int DB_V1 = 1;
    /*
     * Use dynamically generated IV (IV_V2) in data encryption
     */
    public static final int DB_V2 = 2;
    /*
     * Add Bugs table to the encrypted DB, migrate old bugs
     */
    public static final int DB_V3 = 3;
    /*
     * Add Fatal hangs table to the encrypted DB
     */
    public static final int DB_V4 = 4;

    /**
     * Add priority column to non fatals table
     */
    public static final int DB_V5 = 5;
    /*
     * Add Terminations table to the encrypted DB
     */
    public static final int DB_V6 = 6;
    /**
     * Altering fatal hangs table to add activity name attribute.
     * Dropping all existing fatal hangs.
     * Adding V3 Sessions and experiments
     */
    public static final int DB_V7 = 7;

    /**
     * Adds uuid column to terminations and fatal hangs tables
     * Adds a table for session/incident linking
     */
    public static final int DB_V8 = 8;

    /**
     * - Removes last activity column from terminations table
     * - Drop non fatals and non fatals occurrences tables to migrate them to diagnostics database
     */
    public static final int DB_V9 = 9;

    /**
     * - Adds rating_dialog_detection column to v3 sessions table
     */
    public static final int DB_V10 = 10;
    /**
     * adds locale, screen size and random id to v3 session
     */
    public static final int DB_V11 = 11;
    /**
     * Adds metadata table for session-replay
     */
    public static final int DB_V12 = 12;
    /**
     * Adds sr_enabled column to session v3 table
     */
    public static final int DB_V13 = 13;

    /**
     * Adds connection_error column to bugs table
     */
    public static final int DB_V14 = 14;

    /**
     * Adds Features flags and sessions features flags tables into instabug database
     */
    public static final int DB_V15 = 15;

    /**
     * Adds actionable_consent column to bugs table
     */
    public static final int DB_V16 = 16;

    /**
     * Adds frustrating_experience_internal_id and frustrating_experience_internal_id
     */
    public static final int DB_V17 = 17;
    /**
     * Change status of all OFFLINE SR sessions to READY_FOR_SYNC
     */
    public static final int DB_V18 = 18;



    public static final int CURRENT_VERSION = DB_V18;
}
