package com.instabug.library.internal.storage.cache.db.migrations

import android.database.sqlite.SQLiteDatabase
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.*
import com.instabug.library.internal.storage.cache.db.MigrationUtilities.columnExists

private const val ALTER_TABLE_QUERY = "ALTER TABLE %s ADD COLUMN %s%s DEFAULT 0"

class Migration_40_41 : Migration {

    override fun migrate(db: SQLiteDatabase?) {
        db?.apply {
            addFragmentsTables()
            addFragmentsColumnsToSessionMetadata()
            addUserModifiedToNetworkLogs()
        }
    }

    private fun SQLiteDatabase.addFragmentsTables() {
        execSQL(APMFragmentEntry.CREATE_TABLE_QUERY)
        execSQL(APMFragmentEventsEntry.CREATE_TABLE_QUERY)
    }

    private fun SQLiteDatabase.addFragmentsColumnsToSessionMetadata() {
        val spansCountExists = columnExists(
            APMSessionMetaDataEntry.TABLE_NAME,
            APMSessionMetaDataEntry.COLUMN_FRAGMENT_SPANS_COUNT
        )
        APMSessionMetaDataEntry.COLUMN_FRAGMENT_SPANS_COUNT.takeUnless { spansCountExists }
            ?.let { addColumn(it) }

        val droppedSpansCountExists = columnExists(
            APMSessionMetaDataEntry.TABLE_NAME,
            APMSessionMetaDataEntry.COLUMN_FRAGMENT_SPANS_DROPPED_COUNT
        )
        APMSessionMetaDataEntry.COLUMN_FRAGMENT_SPANS_DROPPED_COUNT.takeUnless { droppedSpansCountExists }
            ?.let { addColumn(it) }
    }

    private fun SQLiteDatabase.addColumn(columnName: String) = ALTER_TABLE_QUERY.format(
        APMSessionMetaDataEntry.TABLE_NAME,
        columnName,
        INTEGER_TYPE
    ).let { query -> execSQL(query) }

    private fun SQLiteDatabase.addUserModifiedToNetworkLogs() {
        execSQL(
            "ALTER TABLE ${APMNetworkLogEntry.TABLE_NAME}" +
                    " ADD COLUMN ${APMNetworkLogEntry.COLUMN_USER_MODIFIED}$BOOLEAN_TYPE$DEFAULT 0"
        )
        execSQL(
            "ALTER TABLE ${DanglingAPMNetworkLogEntry.TABLE_NAME}" +
                    " ADD COLUMN ${DanglingAPMNetworkLogEntry.COLUMN_USER_MODIFIED}$BOOLEAN_TYPE$DEFAULT 0"
        )
    }
}