package com.instabug.library.internal.storage.cache.db.migrations;

import android.annotation.SuppressLint;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;

import com.instabug.library.internal.storage.cache.db.InstabugDbContract;

/**
 * Drops bugs table if exists
 */
public class Migration_33_34 implements Migration {

    @SuppressLint("ERADICATE_NULLABLE_DEREFERENCE")
    @Override
    public void migrate(SQLiteDatabase db) {
        if (db != null) {
            try (Cursor cursor = db.query(InstabugDbContract.BugEntry.TABLE_NAME, null, null, null, null, null, null)) {
                if (cursor != null && cursor.getCount() > 0) {
                    return;
                }
                db.execSQL(InstabugDbContract.BugEntry.DROP_TABLE);
            } catch (Exception e) {
                db.execSQL(InstabugDbContract.BugEntry.DROP_TABLE);
            }
        }
    }
}
