package com.instabug.library.internal.storage.cache.db.migrations;

import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.COMMA_SEP;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SessionEntry.COLUMN_APP_TOKEN;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SessionEntry.COLUMN_APP_VERSION;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SessionEntry.COLUMN_CRASH_REPORTING_ENABLED;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SessionEntry.COLUMN_DEVICE;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SessionEntry.COLUMN_DURATION;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SessionEntry.COLUMN_ID;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SessionEntry.COLUMN_OS;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SessionEntry.COLUMN_PRODUCTION_USAGE;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SessionEntry.COLUMN_SDK_VERSION;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SessionEntry.COLUMN_STARTED_AT;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SessionEntry.COLUMN_STITCHED_SESSION_LEAD;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SessionEntry.COLUMN_SYNC_STATUS;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SessionEntry.COLUMN_USERS_PAGE_ENABLED;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SessionEntry.COLUMN_USER_ATTRIBUTES;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SessionEntry.COLUMN_USER_ATTRIBUTES_KEYS;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SessionEntry.COLUMN_USER_EMAIL;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SessionEntry.COLUMN_USER_EVENTS;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SessionEntry.COLUMN_USER_EVENTS_KEYS;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SessionEntry.COLUMN_USER_NAME;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SessionEntry.COLUMN_UUID;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SessionEntry.TABLE_NAME;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;

import androidx.annotation.VisibleForTesting;

import com.instabug.library.internal.storage.cache.db.InstabugDbContract;

public class Migration_31_32 implements Migration {


    @Override
    public void migrate(SQLiteDatabase db) {
        if (!doesColumnExistInTable(db, TABLE_NAME, COLUMN_PRODUCTION_USAGE)) {
            // SQLite does not fully support ALTER TABLE statements. The workaround to altering an
            // existing column's type is to create a new table with a temporary name, copy everything to
            // the new table, drop the old table and then rename the new table to its original name.
            String originalTableName = InstabugDbContract.SessionEntry.TABLE_NAME;
            String tempTableName = InstabugDbContract.SessionEntry.TABLE_NAME + "_temp";
            // create new table with temp name.
            createTable(db, tempTableName);
            // copy values from old table to new table.
            copyValues(db, originalTableName, tempTableName, getColumnsCommaSeparated());
            // drop old table.
            dropTable(db, originalTableName);
            // rename the new table to its original name.
            renameTable(db, tempTableName, originalTableName);
        }
    }

    private void createTable(SQLiteDatabase database, String tableName) {
        database.execSQL("CREATE TABLE IF NOT EXISTS " + tableName +
                " ( " + COLUMN_ID + " TEXT, "
                + COLUMN_STARTED_AT + " INTEGER, "
                + COLUMN_DURATION + " INTEGER, "
                + COLUMN_USER_ATTRIBUTES + " TEXT, "
                + COLUMN_USER_EVENTS + " TEXT, "
                + COLUMN_USER_ATTRIBUTES_KEYS + " TEXT, "
                + COLUMN_USER_EVENTS_KEYS + " TEXT, "
                + COLUMN_USER_EMAIL + " TEXT, "
                + COLUMN_UUID + " TEXT, "
                + COLUMN_USER_NAME + " TEXT, "
                + COLUMN_OS + " TEXT, "
                + COLUMN_APP_TOKEN + " TEXT, "
                + COLUMN_DEVICE + " TEXT, "
                + COLUMN_SDK_VERSION + " TEXT, "
                + COLUMN_APP_VERSION + " TEXT, "
                + COLUMN_CRASH_REPORTING_ENABLED + " INTEGER, "
                + COLUMN_USERS_PAGE_ENABLED + " INTEGER, "
                + COLUMN_SYNC_STATUS + " INTEGER, "
                + COLUMN_PRODUCTION_USAGE + " TEXT DEFAULT \"\", "
                + COLUMN_STITCHED_SESSION_LEAD + " INTEGER )");
    }


    @VisibleForTesting
    public void copyValues(SQLiteDatabase db, String oldTable, String newTable, String columns) {
        db.execSQL("INSERT INTO " + newTable + "(" + columns + ")"
                + " SELECT " + columns
                + " FROM " + oldTable);
    }

    private String getColumnsCommaSeparated() {
        return COLUMN_ID + COMMA_SEP
                + COLUMN_STARTED_AT + COMMA_SEP
                + COLUMN_DURATION + COMMA_SEP
                + COLUMN_USER_ATTRIBUTES + COMMA_SEP
                + COLUMN_USER_EVENTS + COMMA_SEP
                + COLUMN_USER_ATTRIBUTES_KEYS + COMMA_SEP
                + COLUMN_USER_EVENTS_KEYS + COMMA_SEP
                + COLUMN_USER_EMAIL + COMMA_SEP
                + COLUMN_UUID + COMMA_SEP
                + COLUMN_USER_NAME + COMMA_SEP
                + COLUMN_OS + COMMA_SEP
                + COLUMN_APP_TOKEN + COMMA_SEP
                + COLUMN_DEVICE + COMMA_SEP
                + COLUMN_SDK_VERSION + COMMA_SEP
                + COLUMN_APP_VERSION + COMMA_SEP
                + COLUMN_CRASH_REPORTING_ENABLED + COMMA_SEP
                + COLUMN_USERS_PAGE_ENABLED + COMMA_SEP
                + COLUMN_SYNC_STATUS + COMMA_SEP
                + COLUMN_STITCHED_SESSION_LEAD;
    }

    @VisibleForTesting
    public void dropTable(SQLiteDatabase db, String tableName) {
        db.execSQL("DROP TABLE IF EXISTS " + tableName);
    }

    @VisibleForTesting
    public void renameTable(SQLiteDatabase db, String oldTableName, String newTableName) {
        db.execSQL("ALTER TABLE " + oldTableName + " RENAME TO " + newTableName);
    }

    private boolean doesColumnExistInTable(SQLiteDatabase db, String tableName, String columnToCheck) {
        Cursor cursor = null;
        boolean exist;
        try {
            cursor = db.rawQuery("SELECT * FROM " + tableName + " LIMIT 0", new String[]{});
            exist = cursor.getColumnIndex(columnToCheck) != -1;
        } catch (Exception e) {
            exist = false;
        } finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return exist;
    }
}
