package com.instabug.library.internal.storage.cache.db.migrations;

import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SessionEntry.COLUMN_APP_TOKEN;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SessionEntry.COLUMN_APP_VERSION;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SessionEntry.COLUMN_CRASH_REPORTING_ENABLED;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SessionEntry.COLUMN_DEVICE;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SessionEntry.COLUMN_OS;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SessionEntry.COLUMN_SDK_VERSION;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SessionEntry.COLUMN_SYNC_STATUS;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SessionEntry.COLUMN_USERS_PAGE_ENABLED;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SessionEntry.COLUMN_USER_ATTRIBUTES_KEYS;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SessionEntry.COLUMN_USER_EVENTS_KEYS;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SessionEntry.TABLE_NAME;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;

import com.instabug.library.BuildConfig;
import com.instabug.library.Instabug;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.internal.device.InstabugDeviceProperties;
import com.instabug.library.internal.storage.cache.db.InstabugDBVersions;
import com.instabug.library.internal.storage.cache.db.InstabugDbContract;
import com.instabug.library.model.session.SyncStatus;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.DeviceStateProvider;

import org.json.JSONArray;

/**
 * Allows the database to migrate from version 17 to version 18
 * <p>
 * Schemas are defined in {@link InstabugDbContract}. Any changes to these schemas will require
 * a migration.
 *
 * @see InstabugDBVersions
 */
public class Migration_17_18 implements Migration {

    @Override
    public void migrate(SQLiteDatabase db) {
        db.execSQL("ALTER TABLE " + TABLE_NAME
                + " ADD COLUMN " + COLUMN_OS + " TEXT"
                + " DEFAULT " + "\"SDK Level " + InstabugDeviceProperties.getCurrentOSLevel() + "\"");

        db.execSQL("ALTER TABLE " + TABLE_NAME
                + " ADD COLUMN " + COLUMN_DEVICE + " TEXT"
                + " DEFAULT \"" + InstabugDeviceProperties.getDeviceType() + "\"");

        db.execSQL("ALTER TABLE " + TABLE_NAME
                + " ADD COLUMN " + COLUMN_SDK_VERSION + " TEXT"
                + " DEFAULT \"" + BuildConfig.SDK_VERSION + "\"");

        Context context = Instabug.getApplicationContext();
        String appVersion = context == null ? null : DeviceStateProvider.getAppVersion(context);
        db.execSQL("ALTER TABLE " + TABLE_NAME
                + " ADD COLUMN " + COLUMN_APP_VERSION + " TEXT"
                + " DEFAULT \"" + appVersion + "\"");

        int crashReportingEnabled = InstabugCore.isCrashReportingEnabled() ? 1 : 0;
        db.execSQL("ALTER TABLE " + TABLE_NAME
                + " ADD COLUMN " + COLUMN_CRASH_REPORTING_ENABLED + " INTEGER"
                + " DEFAULT " + crashReportingEnabled);

        db.execSQL("ALTER TABLE " + TABLE_NAME
                + " ADD COLUMN " + COLUMN_SYNC_STATUS + " INTEGER"
                + " DEFAULT " + SyncStatus.OFFLINE);

        String appToken = SettingsManager.getInstance().getAppToken();
        db.execSQL("ALTER TABLE " + TABLE_NAME
                + " ADD COLUMN " + COLUMN_APP_TOKEN + " TEXT"
                + " DEFAULT \"" + appToken + "\"");

        String emptyArray = new JSONArray().toString();
        db.execSQL("ALTER TABLE " + TABLE_NAME
                + " ADD COLUMN " + COLUMN_USER_EVENTS_KEYS + " TEXT"
                + " DEFAULT \"" + emptyArray + "\"");

        db.execSQL("ALTER TABLE " + TABLE_NAME
                + " ADD COLUMN " + COLUMN_USER_ATTRIBUTES_KEYS + " TEXT"
                + " DEFAULT \"" + emptyArray + "\"");

        db.execSQL("ALTER TABLE " + TABLE_NAME
                + " ADD COLUMN " + COLUMN_USERS_PAGE_ENABLED + " INTEGER"
                + " DEFAULT " + 1);
    }
}
