package com.instabug.library.internal.storage.cache.db.migrations;

import android.database.sqlite.SQLiteDatabase;

import com.instabug.library.internal.storage.cache.db.InstabugDBVersions;
import com.instabug.library.internal.storage.cache.db.InstabugDbContract;
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.UserAttributesEntry;
import com.instabug.library.model.UserAttribute;

/**
 * Allows the database to migrate from version 14 to version 15
 * <p>
 * Schemas are defined in {@link InstabugDbContract}. Any changes to these schemas will require
 * a migration.
 *
 * @see InstabugDBVersions
 */
public class Migration_14_15 implements Migration {

    @Override
    public void migrate(SQLiteDatabase db) {
        db.execSQL("ALTER TABLE " + UserAttributesEntry.TABLE_NAME
                + " ADD COLUMN " + UserAttributesEntry.COLUMN_TYPE + " INTEGER"
                + " DEFAULT " + UserAttribute.Type.SDK);
    }
}
