package com.instabug.library.internal.storage.cache.db.contract.apm

import com.instabug.library.diagnostics.diagnostics_db.BOOLEAN_TYPE
import com.instabug.library.diagnostics.diagnostics_db.INTEGER_TYPE
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.APMSessionEntry
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.AUTO_INCREMENT
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.COMMA_SEP
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.CONSTRAINT
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.CREATE_TABLE_STATEMENT
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.DEFAULT
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.DELETE_FROM
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.DROP_STATEMENT
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.FOREIGN_KEY
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.ON_DELETE_CASCADE
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.PRIMARY_KEY
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.REFERENCES
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.TEXT_TYPE

object ApmAppFlowEntry {

    const val TABLE_NAME = "apm_flow"

    const val COLUMN_ID = "id"
    const val COLUMN_NAME = "name"
    const val COLUMN_START_TIMESTAMP_MU = "start_time_stamp_mu"
    const val COLUMN_START_TIME_MU = "start_time_mu"
    const val COLUMN_END_TIME_MU = "end_time_mu"
    const val COLUMN_END_REASON = "end_reason"
    const val COLUMN_FIRST_CORE_SESSION_ID = "first_core_session_id"
    const val COLUMN_APM_SESSION_ID = "apm_session_id"
    const val COLUMN_APP_LAUNCH_ID = "app_launch_id"
    const val COLUMN_IS_BACKGROUND = "is_background"
    const val COLUMN_IS_ENDED = "is_ended"

    val CREATE_TABLE_QUERY: String
        get() =
            "$CREATE_TABLE_STATEMENT$TABLE_NAME ( " +
                    "$COLUMN_ID$INTEGER_TYPE$PRIMARY_KEY$AUTO_INCREMENT$COMMA_SEP" +
                    "$COLUMN_NAME$TEXT_TYPE$COMMA_SEP" +
                    "$COLUMN_START_TIMESTAMP_MU$INTEGER_TYPE$COMMA_SEP" +
                    "$COLUMN_START_TIME_MU$INTEGER_TYPE$COMMA_SEP" +
                    "$COLUMN_END_TIME_MU$INTEGER_TYPE$COMMA_SEP" +
                    "$COLUMN_END_REASON$INTEGER_TYPE$DEFAULT 0 $COMMA_SEP" +
                    "$COLUMN_FIRST_CORE_SESSION_ID$TEXT_TYPE$COMMA_SEP" +
                    "$COLUMN_APM_SESSION_ID$INTEGER_TYPE$COMMA_SEP" +
                    "$COLUMN_APP_LAUNCH_ID$INTEGER_TYPE$COMMA_SEP" +
                    "$COLUMN_IS_BACKGROUND$BOOLEAN_TYPE$COMMA_SEP" +
                    "$COLUMN_IS_ENDED$BOOLEAN_TYPE$DEFAULT 0 $COMMA_SEP"+
                    "$CONSTRAINT$COLUMN_APM_SESSION_ID" +
                    "$FOREIGN_KEY($COLUMN_APM_SESSION_ID) $REFERENCES" +
                    "${APMSessionEntry.TABLE_NAME}(${APMSessionEntry.COLUMN_ID}) " +
                    "$ON_DELETE_CASCADE )"

    val DROP_TABLE_QUERY: String get() = "$DROP_STATEMENT$TABLE_NAME"
    val DELETE_ALL: String get() = "$DELETE_FROM$TABLE_NAME"
}