package com.instabug.library.internal.storage.cache;

import com.instabug.library.Constants;
import com.instabug.library.model.AssetEntity;
import com.instabug.library.util.InstabugSDKLogger;

import java.util.List;

/**
 * @author mesbah.
 */
public class AssetCache extends InMemoryCache<String, AssetEntity> {

    public AssetCache(String mId) {
        super(mId);
    }

    @Override
    public void invalidate() {
        List<AssetEntity> assetEntities = getValues();
        for (AssetEntity assetEntity : assetEntities) {
            InstabugSDKLogger.d(Constants.LOG_TAG, "Delete file: " + assetEntity.getFile().getPath()
                    + "," + assetEntity.getFile().delete());
        }
        super.invalidate();
    }
}
