package com.instabug.library.internal.sharedpreferences

import android.content.SharedPreferences

abstract class ReadWriteStrategyPreferenceProperty<T>(
    key: String,
    defaultValue: T,
    private val propertyAccessStrategy: ReadWriteStrategy<T> = DefaultReadWriteStrategy()
) : PreferencesProperty<T>(key, defaultValue) {

    override fun SharedPreferences.get(): T =
        with(propertyAccessStrategy) {
            get(key, defaultValue)
        }

    override fun SharedPreferences.Editor.put(value: T): SharedPreferences.Editor =
        with(propertyAccessStrategy) {
            put(key, value)
        }

    interface ReadWriteStrategy<T> {
        fun SharedPreferences.get(key: String, default:T): T
        fun SharedPreferences.Editor.put(key: String, value: T): SharedPreferences.Editor
    }

}