package com.instabug.library.internal.filestore

import androidx.annotation.WorkerThread
import java.io.File

/**
 * This class represents a directory in the file system.
 * It can distinguish between files and directories.
 * @param parent The parent directory of this directory.
 * @param child The name of this directory.
 */
open class Directory(parent: File, child: String) : File(parent, child)

/**
 * A contract that represents a [Directory] with spans providing shorthand notions
 * for [currentDirectory] & [oldDirectories]
 */
interface SpanDirectoriesOwner<SpanDir : Directory> {
    val currentDirectory: SpanDir?
    val oldDirectories: List<SpanDir>
}

abstract class SpansDirectory<SpanDir : Directory>(
    parent: File,
    child: String
) : Directory(parent, child), SpanDirectoriesOwner<SpanDir>

// region Directory Factories

interface DirectoryFactory<Out : Directory> {
    @WorkerThread
    operator fun invoke(): Out?
}

interface SpansDirectoryFactory<Out : SpansDirectory<*>> : DirectoryFactory<Out> {
    fun setCurrentSpanId(spanId: String?)
}

// endregion