package com.instabug.library.internal.dataretention.core;

import java.util.Collection;
import java.util.Collections;

import androidx.annotation.NonNull;

/**
 * This policy sets the required retention periods for specified categories of user's data and sets
 * out the minimum standards to be applied when destroying certain information.
 * This policy can be applied to all user's information (i.e. UserEvents, UserAttributes, etc...)
 */
public abstract class DisposalPolicy<T extends Record<?>> {

    /**
     * @return The scope of data in which the SQLDisposalPolicy should be applied to
     */
    @NonNull
    public abstract Scope<T> scope();

    /**
     * Represents the exception/corner cases in which the data may need to be retained for a longer
     * period of time even though it has been expired. Unless the rules are not empty, the required
     * retention period for such data will be deemed to be the {@link Contract#maxRetentionPeriodMillis()}
     *
     * @return A list of exception rules (if any). Empty list by default
     */
    @NonNull
    public Collection<? extends Rule<T>> exceptionRules() {
        return Collections.emptyList();
    }

    /**
     * Specifies how long data are to be retained.
     */
    @NonNull
    public abstract Contract retentionContract();
}
