package com.instabug.library.frustratingexperience

import androidx.annotation.StringDef
import com.instabug.library.core.eventbus.instabugeventbus.InstabugEventBus
import com.instabug.library.frustratingexperience.FrustratingExperienceType.Companion.FORCE_RESTART

object FrustratingExperienceEventBus : InstabugEventBus<FrustratingExperienceEvent>()


sealed class FrustratingExperienceEvent {
    class Detected(val type: @FrustratingExperienceType String, val internalId: Long) :
        FrustratingExperienceEvent()

    class BugReportSaved(val internalId: Long): FrustratingExperienceEvent()

    class Synced(val internalId: Long, val externalId: String?): FrustratingExperienceEvent()

}

@Retention(AnnotationRetention.SOURCE)
@Target(AnnotationTarget.TYPE)
@StringDef(
    FORCE_RESTART
)
annotation class FrustratingExperienceType {
    companion object {

        const val FORCE_RESTART = "Force restarts"
    }
}


