package com.instabug.library.encryption

import androidx.annotation.VisibleForTesting
import com.instabug.library.Constants
import com.instabug.library.diagnostics.IBGDiagnostics
import com.instabug.library.util.InstabugSDKLogger
import java.security.Key
import javax.crypto.spec.SecretKeySpec

object StaticKeyProvider {


    init {
        try {
            System.loadLibrary("ibg-native")
        } catch (e: UnsatisfiedLinkError) {
            InstabugSDKLogger.e(
                Constants.LOG_TAG,
                "Error loading native library while getting static encryption key"
            )
            IBGDiagnostics.reportNonFatal(e, "Error loading native library")
        }
    }

    @JvmStatic
    fun getStaticKey(): Key? {
        return try {
            SecretKeySpec(getKeyString().toByteArray(), "AES")
        } catch (e:UnsatisfiedLinkError) {
            InstabugSDKLogger.e(Constants.LOG_TAG, "Error loading native library while getting static encryption key")
            null
        }
    }

    @JvmStatic
    @VisibleForTesting
    external fun getKeyString(): String
}