package com.instabug.library.diagnostics.sdkEvents

import com.instabug.library.diagnostics.sdkEvents.models.SDKEvent

interface SDKEventsManager {

    // adds threading on cachingManager.saveEvent()
    fun saveEvent(event: SDKEvent)

    // calls cachingManager.saveEvent() immediately
    fun saveEventImmediately(event: SDKEvent)

    // adds threading on cachingManager.deleteManyEvents()
    fun deleteManyEvents(keys: Collection<String>?)

    // adds threading on cachingManager.clearCache()
    fun clearCache()

    // adds threading on cachingManager.updateSyncedRecords()
    fun updateSyncedRecords(syncedRecords: List<SDKEvent>)

    // adds threading on cachingManager.deleteZeroCountedEvents()
    fun deleteZeroCountedEvents()
}