package com.instabug.library.diagnostics.nonfatals

import androidx.annotation.VisibleForTesting
import com.instabug.library.settings.PerSessionSettings

object NonFatalsRecursionDetector {

    @VisibleForTesting
    var reportedNonFatalsCount: Int = 0


    private const val maxReportedNumber = 5
    @VisibleForTesting
    const val databaseFileName = "DiagnosticsDbManager.kt"

    @JvmStatic
    fun onNonFatalReported(fileName: String?) {
        if (fileName == databaseFileName) {
            reportedNonFatalsCount++


            takeIf { reportedNonFatalsCount >= maxReportedNumber }?.apply {
                PerSessionSettings.getInstance()?.isNonFatalsDisabledTemporarily = true
            }
        }
    }
}