package com.instabug.library.diagnostics.nonfatals;

import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;

import com.instabug.library.diagnostics.nonfatals.model.NonFatal;

import java.util.List;

/**
 * Created by Shannan on 06/09/2021.
 */
public interface NonFatalsManager {
    /**
     * Caches the reported non-fatal to db
     *
     * @param nonFatal the non-fatal to be cached
     */
    @WorkerThread
    void saveNonFatal(@NonNull NonFatal nonFatal);

    /**
     * Clears all non-fatals cache
     */
    void clearCache();

    List<NonFatal> getNonFatals();

    void cleanStaleStateFiles();

    void cleanNonFatalsWithNoOccurrences();
}