package com.instabug.library.diagnostics.nonfatals;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.instabug.library.Constants;
import com.instabug.library.diagnostics.nonfatals.model.NonFatal;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.ThreadUtils;

public class NonFatalFormatter {

    public static NonFatal createNonFatal(@NonNull Throwable throwable, @Nullable StackTraceElement instabugElement, String message, @NonFatal.Priority int priority) {
        NonFatal nonFatal = new NonFatal();
        try {
            String name = throwable.getClass().getName();
            nonFatal.setExceptionType(name);
            nonFatal.setMessage(message);
            nonFatal.setStackTrace(ThreadUtils.buildStackTraceFromElements(throwable.getStackTrace(), throwable.getClass().getCanonicalName()));
            nonFatal.setPriority(priority);


            if (instabugElement != null) {
                if (instabugElement.getClassName() != null) {
                    nonFatal.setDeclaringClass(instabugElement.getClassName());
                }
                if (instabugElement.getFileName() != null) {
                    nonFatal.setFileName(instabugElement.getFileName());
                }
                if (instabugElement.getMethodName() != null) {
                    nonFatal.setMethodName(instabugElement.getMethodName());
                }
                nonFatal.setLineNumber(instabugElement.getLineNumber());
            } else {
                InstabugSDKLogger.e(Constants.LOG_TAG, "Incomplete non-fatal stacktrace");
            }
        } catch (Exception e) {
            InstabugSDKLogger.e(Constants.LOG_TAG, "Something went wrong while creating non-fatal", e);
        }
        return nonFatal;
    }
}
