package com.instabug.library.diagnostics.customtraces

import com.instabug.library.diagnostics.customtraces.model.IBGCustomTrace

interface CustomTracesManager {

    /**
     * Clear all traces in the db
     */
    fun clearCache()

    /**
     * Removes traces whose duration was not set from the db
     */
    fun removeUnEndedTraces()

    /**
     * Starts a custom trace
     *
     * @param traceName identifier
     * @param startTime time when the trace started
     */
    fun startTrace(traceName: String?, startTime: Long): IBGCustomTrace?

    /**
     * Inserts a trace into db
     *
     * @param traceName identifier
     * @param startTime time when the trace started
     * @param endTime time when the trace ended
     */
    fun logTrace(traceName: String?, startTime: Long, endTime: Long)

    /**
     * Updates attribute to trace
     *
     * @param traceId to use as a foreign key
     * @param key attribute key
     * @param value attribute value
     *
     * @return true if attribute was inserted to db
     */
    fun updateAttribute(traceId: Long, key: String, value: String?): Boolean?

    /**
     * Adds attribute to trace
     *
     * @param traceId to use as a foreign key
     * @param key attribute key
     * @param value attribute value
     *
     * @return true if attribute was inserted to db
     */
    fun setAttribute(traceId: Long, key: String, value: String?): Boolean?

    /**
     * ends custom trace
     *
     * @param traceId id of the trace in the db
     * @param duration trace duration
     *
     * @return true if trace was updated in the db successfully
     */
    fun endTrace(traceId: Long, duration: Long, endedInBG: Boolean): Boolean?

    fun getAllTraces(): List<IBGCustomTrace>?

    fun clearSyncedTraces(traces : List<IBGCustomTrace>?)

    fun clearTracesForFlag(flagName: String)
}