package com.instabug.library.datahub

import com.instabug.library.internal.filestore.SpanSelector
import com.instabug.library.internal.servicelocator.CoreServiceLocator
import com.instabug.library.model.State
import com.instabug.library.util.extenstions.runOrLogAndReport
import java.util.concurrent.Future

class HubReportModifier private constructor(private val stores: List<HubDataStore<*>>) {

    private val dataFutures: MutableList<Future<Boolean>> = mutableListOf()

    fun prepare(state: State, spanSelector: SpanSelector<HubDirectory, HubLaunchDirectory>) {
        synchronized(this) {
            runCatching {
                stores.filterIsInstance<ReportContributor>().forEach { contributor ->
                    dataFutures.add(contributor.contribute(state, spanSelector))
                }
            }.runOrLogAndReport("Error while preparing ReportModifier.")
        }
    }

    fun finish() {
        synchronized(this) {
            runCatching { dataFutures.forEach { future -> future.get() } }
                .runOrLogAndReport("Error while finalizing ReportModifier.")
        }
    }

    class Builder {
        private var withIBGLogs = true

        fun withIBGLogs(with: Boolean): Builder = apply { withIBGLogs = with }

        fun buildWithDefaultStores() = CoreServiceLocator.dataStores
            .filterNot { store -> !withIBGLogs && store is IBGLogsHubDataStore }
            .let(::HubReportModifier)
    }
}