package com.instabug.library.core.ui;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.app.DialogFragment;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;

import com.instabug.library.util.InstabugSDKLogger;

import androidx.annotation.CallSuper;
import androidx.annotation.IdRes;
import androidx.annotation.LayoutRes;
import androidx.annotation.Nullable;

public abstract class BaseDialogFragment<P extends BaseContract.Presenter> extends DialogFragment
        implements BaseContract.View<DialogFragment> {

    @Nullable
    protected P presenter;
    @Nullable
    protected View rootView;

    @Override
    @SuppressLint("ERADICATE_PARAMETER_NOT_NULLABLE")
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @CallSuper
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, Bundle savedInstanceState) {
        Dialog dialog = getDialog();
        if (dialog != null && getDialog().getWindow() != null) {
            getDialog().getWindow().requestFeature(Window.FEATURE_NO_TITLE);
        }

        rootView = inflater.inflate(getLayout(), container, false);

        initViews(rootView, savedInstanceState);

        return rootView;
    }

    @Override
    @SuppressLint("ERADICATE_PARAMETER_NOT_NULLABLE")
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
    }

    @Override
    public void onStart() {
        super.onStart();
    }

    @Override
    public void onStop() {
        super.onStop();
    }

    @Override
    public void onDestroyView() {
        rootView = null;
        super.onDestroyView();
    }


    @Override
    public DialogFragment getViewContext() {
        return this;
    }

    @Override
    public void finishActivity() {
        getActivity().finish();
    }

    /**
     * Look for a child view with the given id.  If this view has the given
     * id, return this view.
     *
     * @param id The id to search for.
     * @return The view that has the given id in the hierarchy or null
     */
    @Nullable
    protected <T extends View> T findViewById(@IdRes int id) {
        if (rootView == null) return null;
        return rootView.findViewById(id);
    }

    /**
     * @return layout resource id.
     */
    protected abstract @LayoutRes
    int getLayout();

    /**
     * Init fragment views
     *
     * @param rootView fragment root view.
     * @param savedInstanceState saved instance bundle
     */
    protected abstract void initViews(View rootView, Bundle savedInstanceState);
}
