package com.instabug.library.core.eventbus.instabugeventbus

import com.instabug.library.core.eventbus.eventpublisher.EventPublisher
import com.instabug.library.core.eventbus.eventpublisher.IBGDisposable
import com.instabug.library.core.eventbus.eventpublisher.Subscriber

/**
 * Base class for custom EventBus implementation using EventPublisher.
 * For RX version of this class check {@link eventbus.EventBus} class.
 */
open class InstabugEventBus<T> {

    private val eventPublisher: EventPublisher<T>

    init {
        eventPublisher = EventBusEventPublisher()
    }

    open fun <E : T> post(event: E) {
        eventPublisher.post(event)
    }

    /**
     * Subscribe or register for events.
     *
     * @param subscriber that will receive the event values or errors if they occurred while posting events.
     */
    open fun subscribe(subscriber: Subscriber<T>): IBGDisposable {
        return eventPublisher.subscribe(subscriber)
    }

}