package com.instabug.library.apichecker;

import androidx.annotation.Nullable;

/**
 * A functional interface similar to Runnable but allows returning a value and throwing a checked exception.
 */
@FunctionalInterface
public interface ReturnableRunnable<T> {

    /**
     * Runs a block of code, return value of type <T>.
     *
     * @return the operation results
     */
    @Nullable
    T run();
}
