package com.instabug.library

import com.instabug.library.sessionreplay.model.SessionMetadata

/**
A callback function that instructs Instabug to synchronize a Session Replay or not.
 *
 * This callback enhances user control and transparency by allowing developers to
 * decide whether a Session Replay should be synchronized based on the provided
 * [SessionMetadata]. This metadata contains information about the previous session
 * */
fun interface SessionSyncListener {

    /**
     *
     *@param metadata Metadata associated with the previous session.
     *@return `true` to synchronize the Session Replay, `false` to drop it.
     **/
    fun onSessionReadyToSync(metadata: SessionMetadata): Boolean
}
