package com.instabug.library

import androidx.annotation.StringDef
import com.instabug.library.IBGNetworkWorker.Companion.ANNOUNCEMENTS
import com.instabug.library.IBGNetworkWorker.Companion.BUGS
import com.instabug.library.IBGNetworkWorker.Companion.CHATS
import com.instabug.library.IBGNetworkWorker.Companion.CORE
import com.instabug.library.IBGNetworkWorker.Companion.CRASH
import com.instabug.library.IBGNetworkWorker.Companion.FEATURES_REQUEST
import com.instabug.library.IBGNetworkWorker.Companion.SURVEYS

@Retention(AnnotationRetention.RUNTIME)
@StringDef(CORE, BUGS, CHATS, SURVEYS, ANNOUNCEMENTS, CRASH, FEATURES_REQUEST)
annotation class IBGNetworkWorker {

    companion object {
        const val CORE = "CORE"
        const val BUGS = "BUGS"
        const val CHATS = "CHATS"
        const val SURVEYS = "SURVEYS"
        const val ANNOUNCEMENTS = "ANNOUNCEMENTS"
        const val CRASH = "CRASH"
        const val FEATURES_REQUEST = "FEATURES_REQUEST"
    }
}
