/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util.threading;

import android.content.Context;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.instabug.library.Instabug;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.DefensiveRunnableKt;
import com.instabug.library.util.threading.MainThreadExecutor;
import com.instabug.library.util.threading.OrderedExecutorService;
import com.instabug.library.util.threading.PriorityThreadFactory;
import com.instabug.library.util.threading.ReturnableSingleThreadExecutor;
import com.instabug.library.util.threading.SingleThreadPoolExecutor;
import com.instabug.library.util.threading.a;
import com.instabug.library.util.threading.f;
import com.instabug.library.util.threading.g;
import com.instabug.library.util.threading.h;
import com.instabug.library.util.threading.j;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class PoolProvider {
    public static final int NUMBER_OF_CORES = Runtime.getRuntime().availableProcessors();
    private static final int NUMBER_OF_THREADS_FOR_SCHEDULED_EXECUTOR = 4;
    private static volatile PoolProvider instance;
    private static final Map<String, SingleThreadPoolExecutor> singleThreadPoolExecutorhMap;
    private static final Map<String, ReturnableSingleThreadExecutor> returnableSingleThreadPoolExecutorhMap;
    private static final Map<String, g> networkingSingleThreadExecutorMap;
    private static final Map<String, f> monitoredSingleThreadExecutorMap;
    private static final ReturnableSingleThreadExecutor apiExecutor;
    private static final SingleThreadPoolExecutor sessionExecutor;
    private static final SingleThreadPoolExecutor visualUserStepsProvider;
    private static final ReturnableSingleThreadExecutor sharedPrefExecutor;
    private static final SingleThreadPoolExecutor featuresFlagsCheckerExecutor;
    private static final Object lock;
    private final ThreadPoolExecutor forIOTasks;
    private final ScheduledThreadPoolExecutor forScheduledTasks;
    private final Executor mainThreadExecutor;
    private final OrderedExecutorService orderedExecutor;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PoolProvider getInstance() {
        Object object = instance;
        if (object != null) {
            return object;
        }
        object = lock;
        synchronized (object) {
            try {
                PoolProvider poolProvider = instance;
                if (poolProvider != null) {
                    return poolProvider;
                }
                instance = new PoolProvider();
                return instance;
            }
            catch (Throwable throwable) {}
            throw throwable;
        }
    }

    @Nullable
    public static Context getContext() {
        try {
            return Instabug.getApplicationContext();
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
    }

    private PoolProvider() {
        PriorityThreadFactory priorityThreadFactory;
        PriorityThreadFactory priorityThreadFactory2;
        LinkedBlockingQueue<Runnable> linkedBlockingQueue;
        ThreadPoolExecutor threadPoolExecutor;
        int n2 = Math.min(8, NUMBER_OF_CORES * 2);
        ThreadPoolExecutor threadPoolExecutor2 = threadPoolExecutor;
        TimeUnit timeUnit = TimeUnit.SECONDS;
        LinkedBlockingQueue<Runnable> linkedBlockingQueue2 = linkedBlockingQueue;
        linkedBlockingQueue = new LinkedBlockingQueue<Runnable>();
        PriorityThreadFactory priorityThreadFactory3 = priorityThreadFactory2;
        priorityThreadFactory2 = new PriorityThreadFactory("core-io-executor", 10);
        this.forIOTasks = new ThreadPoolExecutor(n2, n2, 10L, timeUnit, linkedBlockingQueue2, priorityThreadFactory3);
        PriorityThreadFactory priorityThreadFactory4 = priorityThreadFactory;
        priorityThreadFactory = new PriorityThreadFactory("core-scheduled-executor", 10);
        this.forScheduledTasks = new ScheduledThreadPoolExecutor(4, priorityThreadFactory4);
        this.mainThreadExecutor = new MainThreadExecutor();
        this.orderedExecutor = new a(threadPoolExecutor2);
    }

    public static void postIOTask(Runnable runnable) {
        if (runnable != null) {
            Runnable runnable2;
            PoolProvider.getInstance().orderedExecutor.execute(() -> {
                Throwable throwable;
                if (PoolProvider.getContext() == null) {
                    return;
                }
                try {
                    throwable.run();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    if (throwable2 instanceof OutOfMemoryError) {
                        InstabugSDKLogger.e("IBG-Core", "low memory, can't run i/o task", throwable);
                    }
                    InstabugSDKLogger.e("IBG-Core", "Error while running IO task", throwable);
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void postOrderedIOTask(@NonNull String key, Runnable runnable) {
        if (runnable != null) {
            void var1_1;
            Runnable runnable2;
            Runnable runnable3;
            String string2 = runnable3;
            runnable3 = runnable2;
            runnable2 = new Runnable((Runnable)var1_1){
                final /* synthetic */ Runnable a;
                {
                    this.a = runnable;
                }

                @Override
                public void run() {
                    if (PoolProvider.getContext() == null) {
                        return;
                    }
                    try {
                        this.a.run();
                    }
                    catch (Throwable throwable) {
                        if (throwable instanceof OutOfMemoryError) {
                            InstabugSDKLogger.e("IBG-Core", "low memory, can't run i/o task", throwable);
                        }
                        InstabugSDKLogger.e("IBG-Core", "Error while running IO task", throwable);
                    }
                }
            };
            PoolProvider.getInstance().orderedExecutor.execute(string2, runnable3);
        }
    }

    public static void postIOTaskWithCheck(Runnable runnable) {
        if (runnable != null) {
            Runnable runnable2;
            if (Looper.myLooper() == Looper.getMainLooper()) {
                PoolProvider.postIOTask(runnable2);
            } else {
                runnable2.run();
            }
        }
    }

    public static <T> Future<T> submitIOTask(Callable<T> callable) {
        Callable<T> callable2;
        return PoolProvider.getInstance().forIOTasks.submit(callable2);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Future<T> submitOrderedIOTask(String key, Callable<T> callable) {
        void var1_1;
        String string2;
        return PoolProvider.getInstance().orderedExecutor.submit(string2, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void postDelayedTask(Runnable runnable, long delayMillis) {
        if (runnable != null) {
            void var1_1;
            Object object;
            Runnable runnable2 = new Runnable((Runnable)object){
                final /* synthetic */ Runnable a;
                {
                    this.a = runnable;
                }

                @Override
                public void run() {
                    if (PoolProvider.getContext() == null) {
                        return;
                    }
                    try {
                        this.a.run();
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        InstabugSDKLogger.e("IBG-Core", "low memory, can't run delayed task", outOfMemoryError);
                    }
                }
            };
            object = TimeUnit.MILLISECONDS;
            PoolProvider.getInstance().forScheduledTasks.schedule(runnable2, (long)var1_1, (TimeUnit)((Object)object));
        }
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static ScheduledFuture<?> postDelayedTaskAtFixedDelay(long initialDelay, long delayMillis, @NonNull Runnable command) {
        void var2_3;
        long l2;
        void var4_2;
        TimeUnit timeUnit = TimeUnit.MILLISECONDS;
        return PoolProvider.getInstance().forScheduledTasks.scheduleWithFixedDelay(() -> PoolProvider.lambda$postDelayedTaskAtFixedDelay$1((Runnable)var4_2), l2, (long)var2_3, timeUnit);
    }

    public static void postMainThreadTaskWithoutCheck(Runnable runnable) {
        if (runnable != null) {
            Runnable runnable2;
            PoolProvider.getInstance().mainThreadExecutor.execute(() -> {
                try {
                    runnable2.run();
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    InstabugSDKLogger.e("IBG-Core", "low memory, can't run main thread task", outOfMemoryError);
                }
            });
        }
    }

    public static void postMainThreadTask(Runnable runnable) {
        if (runnable != null) {
            Runnable runnable2;
            PoolProvider.getInstance().mainThreadExecutor.execute(() -> {
                if (PoolProvider.getContext() == null) {
                    return;
                }
                try {
                    Runnable runnable2;
                    runnable2.run();
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    InstabugSDKLogger.e("IBG-Core", "low memory, can't run main thread task", outOfMemoryError);
                }
            });
        }
    }

    public static <R> FutureTask<R> submitMainThreadTask(Callable<R> task) {
        Callable<R> callable;
        FutureTask<R> futureTask = new FutureTask<R>(callable);
        PoolProvider.postMainThreadTask(futureTask);
        return futureTask;
    }

    /*
     * WARNING - void declaration
     */
    public static void postTask(Executor executor, Runnable runnable) {
        void var1_1;
        if (executor != null && var1_1 != null) {
            Executor executor2;
            executor2.execute(() -> PoolProvider.lambda$postTask$4((Runnable)var1_1));
        }
    }

    public static synchronized Executor getSingleThreadExecutor(String identifier) {
        SingleThreadPoolExecutor singleThreadPoolExecutor;
        String string2;
        Map<String, SingleThreadPoolExecutor> map = singleThreadPoolExecutorhMap;
        if (map.containsKey(string2)) {
            return map.get(string2);
        }
        SingleThreadPoolExecutor singleThreadPoolExecutor2 = singleThreadPoolExecutor;
        singleThreadPoolExecutor2(string2);
        singleThreadPoolExecutor2.setIdentifier(string2).setThreadPoolIdleListener(new j(){

            /*
             * WARNING - void declaration
             */
            @Override
            public void a(String identifier) {
                if (identifier != null) {
                    void var1_1;
                    singleThreadPoolExecutorhMap.remove(var1_1);
                }
            }
        });
        map.put(string2, singleThreadPoolExecutor2);
        return singleThreadPoolExecutor;
    }

    public static synchronized ExecutorService getNetworkingSingleThreadExecutorService(String identifier) {
        return PoolProvider.getNetworkingSingleThreadExecutor(identifier, false);
    }

    public static synchronized Executor getNetworkingSingleThreadExecutor(String identifier) {
        return PoolProvider.getNetworkingSingleThreadExecutor(identifier, false);
    }

    /*
     * WARNING - void declaration
     */
    public static synchronized ExecutorService getNetworkingSingleThreadExecutor(String identifier, boolean retryable) {
        g g2;
        void var1_1;
        String string2;
        Map<String, g> map = networkingSingleThreadExecutorMap;
        if (map.containsKey(string2)) {
            return map.get(string2);
        }
        if (var1_1 != false) {
            h h2;
            g2 = h2;
            h2 = new h(string2);
        } else {
            g g3;
            g2 = g3;
            g3 = new g(string2);
        }
        g2.setIdentifier(string2).setThreadPoolIdleListener(new j(){

            /*
             * WARNING - void declaration
             */
            @Override
            public void a(String identifier) {
                if (identifier != null) {
                    void var1_1;
                    singleThreadPoolExecutorhMap.remove(var1_1);
                }
            }
        });
        map.put(string2, g2);
        return g2;
    }

    public static synchronized ReturnableSingleThreadExecutor getReturnableSingleThreadExecutor(String identifier) {
        ReturnableSingleThreadExecutor returnableSingleThreadExecutor;
        String string2;
        Map<String, ReturnableSingleThreadExecutor> map = returnableSingleThreadPoolExecutorhMap;
        if (map.containsKey(string2)) {
            return map.get(string2);
        }
        ReturnableSingleThreadExecutor returnableSingleThreadExecutor2 = returnableSingleThreadExecutor;
        returnableSingleThreadExecutor2(string2);
        map.put(string2, returnableSingleThreadExecutor2);
        return returnableSingleThreadExecutor;
    }

    public static synchronized f getMonitoredSingleThreadExecutor(String identifier) {
        f f2;
        String string2;
        Map<String, f> map = monitoredSingleThreadExecutorMap;
        if (map.containsKey(string2)) {
            return map.get(string2);
        }
        f f3 = f2;
        f3();
        map.put(string2, f3);
        return f2;
    }

    public static Executor getUserActionsExecutor() {
        return PoolProvider.getSingleThreadExecutor("user-actions-executor");
    }

    public static synchronized Executor getSyncExecutor() {
        return PoolProvider.getSingleThreadExecutor("sync-Executor");
    }

    public static ReturnableSingleThreadExecutor getApiExecutor() {
        return apiExecutor;
    }

    public static SingleThreadPoolExecutor getSessionExecutor() {
        return sessionExecutor;
    }

    public static SingleThreadPoolExecutor getVisualUserStepsProvider() {
        return visualUserStepsProvider;
    }

    public static ReturnableSingleThreadExecutor getSharedPrefExecutor() {
        return sharedPrefExecutor;
    }

    public static ReturnableSingleThreadExecutor getChatsCacheExecutor() {
        return PoolProvider.getReturnableSingleThreadExecutor("chats-cache-executor");
    }

    public static ReturnableSingleThreadExecutor getSurveysDBExecutor() {
        return PoolProvider.getReturnableSingleThreadExecutor("surveys-db-executor");
    }

    public static f getDatabaseExecutor() {
        return PoolProvider.getMonitoredSingleThreadExecutor("IBG-db-executor");
    }

    public static f getDiagnosticsDatabaseExecutor() {
        return PoolProvider.getMonitoredSingleThreadExecutor("IBG-diagnostics-db-executor");
    }

    public static ReturnableSingleThreadExecutor getFilesEncryptionExecutor() {
        return PoolProvider.getReturnableSingleThreadExecutor("Files-Encryption");
    }

    public static Executor getBugsExecutor() {
        return PoolProvider.getSingleThreadExecutor("bugs-executor");
    }

    public static SingleThreadPoolExecutor getFeaturesFlagsCheckerExecutor() {
        return featuresFlagsCheckerExecutor;
    }

    private static /* synthetic */ void lambda$postTask$4(Runnable runnable) {
        if (PoolProvider.getContext() == null) {
            return;
        }
        try {
            Runnable runnable2;
            runnable2.run();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            InstabugSDKLogger.e("IBG-Core", "low memory, can't run task", outOfMemoryError);
        }
    }

    private static /* synthetic */ void lambda$postDelayedTaskAtFixedDelay$1(Runnable command) {
        Runnable runnable;
        if (PoolProvider.getContext() == null) {
            return;
        }
        DefensiveRunnableKt.runDefensive(runnable).run();
    }

    static {
        singleThreadPoolExecutorhMap = new HashMap<String, SingleThreadPoolExecutor>();
        returnableSingleThreadPoolExecutorhMap = new HashMap<String, ReturnableSingleThreadExecutor>();
        networkingSingleThreadExecutorMap = new HashMap<String, g>();
        monitoredSingleThreadExecutorMap = new HashMap<String, f>();
        apiExecutor = new ReturnableSingleThreadExecutor("API-executor");
        sessionExecutor = new SingleThreadPoolExecutor("v3-session");
        visualUserStepsProvider = new SingleThreadPoolExecutor("steps-executor");
        sharedPrefExecutor = new ReturnableSingleThreadExecutor("shared-pref-executor");
        featuresFlagsCheckerExecutor = new SingleThreadPoolExecutor("features-flags-checker-executor");
        lock = new Object();
    }

    public ThreadPoolExecutor getBackgroundExecutor() {
        return this.forIOTasks;
    }

    public ThreadPoolExecutor getIOExecutor() {
        return this.forIOTasks;
    }

    public Executor getMainThreadExecutor() {
        return this.mainThreadExecutor;
    }

    public OrderedExecutorService getOrderedExecutor() {
        return this.orderedExecutor;
    }

    public ScheduledExecutorService getScheduledExecutor() {
        return this.forScheduledTasks;
    }

    public Executor getMainExecutor() {
        return this.mainThreadExecutor;
    }
}

