/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.provider.MediaStore;
import android.widget.ImageView;
import androidx.annotation.DrawableRes;
import androidx.annotation.IntRange;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.instabug.library.Instabug;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.diagnostics.IBGDiagnostics;
import com.instabug.library.internal.servicelocator.CoreServiceLocator;
import com.instabug.library.internal.storage.DiskUtils;
import com.instabug.library.internal.storage.ProcessedBytes;
import com.instabug.library.internal.storage.cache.AssetsCacheManager;
import com.instabug.library.model.AssetEntity;
import com.instabug.library.util.BitmapWorkerTask;
import com.instabug.library.util.DisplayUtils;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.e;
import com.instabug.library.util.threading.PoolProvider;
import com.instabug.library.util.threading.ThreadUtils;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

public class BitmapUtils {
    private static final String ICON_FILE_PREFIX = "icon";

    @Nullable
    public static Bitmap getBitmapFromUri(@NonNull Uri uri) {
        Bitmap bitmap;
        block3: {
            bitmap = null;
            if (Instabug.getApplicationContext() == null) break block3;
            try {
                Uri uri2;
                bitmap = MediaStore.Images.Media.getBitmap((ContentResolver)Instabug.getApplicationContext().getContentResolver(), (Uri)uri2);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                InstabugSDKLogger.e("IBG-Core", "getBitmapFromFilePath returns null because of " + iOException.getMessage());
            }
        }
        return bitmap;
    }

    /*
     * WARNING - void declaration
     */
    public static void compressBitmapAndSave(@NonNull Context context, @NonNull File originalImageFile) {
        void var1_1;
        if (context != null && var1_1 != null) {
            try {
                BitmapUtils.compressBitmapAndSave((File)var1_1);
            }
            catch (Throwable throwable) {
                IBGDiagnostics.reportNonFatalAndLog(throwable, "Error occur while compress images" + throwable.getMessage(), "IBG-Core");
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    private static void compressBitmapAndSave(File originalImageFile) {
        Exception exception2;
        block12: {
            FileOutputStream fileOutputStream;
            FileInputStream fileInputStream;
            block11: {
                FileOutputStream fileOutputStream2;
                FileInputStream fileInputStream2;
                BitmapFactory.Options options;
                int n2;
                File file;
                BitmapFactory.Options options2;
                BitmapFactory.Options options3 = options2;
                new BitmapFactory.Options().inJustDecodeBounds = true;
                FileInputStream fileInputStream3 = new FileInputStream(file);
                FileInputStream fileInputStream4 = fileInputStream3;
                BitmapFactory.decodeStream((InputStream)fileInputStream3, null, (BitmapFactory.Options)options3);
                try {
                    fileInputStream4.close();
                    n2 = 1;
                    while (options3.outWidth / n2 / 2 >= 900 && options3.outHeight / n2 / 2 >= 900) {
                        n2 *= 2;
                    }
                }
                catch (Exception exception2) {}
                options3 = options;
                new BitmapFactory.Options().inSampleSize = n2;
                fileInputStream = fileInputStream2;
                options3 = BitmapFactory.decodeStream((InputStream)new FileInputStream(file), null, (BitmapFactory.Options)options3);
                fileOutputStream = fileOutputStream2;
                fileOutputStream2 = new FileOutputStream(file);
                if (options3 == null) break block11;
                BitmapFactory.Options options4 = options3;
                BitmapFactory.Options options5 = options4;
                options4.compress(BitmapUtils.getImageMimeType(file), 100, (OutputStream)fileOutputStream);
                options5.recycle();
                break block12;
            }
            fileOutputStream.close();
            fileInputStream.close();
            return;
        }
        exception2.printStackTrace();
        InstabugSDKLogger.e("IBG-Core", "bitmap doesn't compressed correctly " + exception2.getMessage());
    }

    private static Bitmap.CompressFormat getImageMimeType(File file) {
        if (file.getName().contains("png")) {
            return Bitmap.CompressFormat.PNG;
        }
        return Bitmap.CompressFormat.JPEG;
    }

    public static void loadBitmap(String localPath, ImageView imageView) {
        String string2;
        Object[] objectArray;
        BitmapWorkerTask bitmapWorkerTask = new BitmapWorkerTask((ImageView)objectArray);
        Object[] objectArray2 = new String[1];
        objectArray = objectArray2;
        objectArray2[0] = string2;
        bitmapWorkerTask.execute(objectArray);
    }

    /*
     * WARNING - void declaration
     */
    public static void loadBitmapWithFallback(String localPath, ImageView imageView, @DrawableRes int fallbackDrawable) {
        String string2;
        void var2_2;
        Object[] objectArray;
        BitmapWorkerTask bitmapWorkerTask = new BitmapWorkerTask((ImageView)objectArray, (int)var2_2);
        Object[] objectArray2 = new String[1];
        objectArray = objectArray2;
        objectArray2[0] = string2;
        bitmapWorkerTask.execute(objectArray);
    }

    /*
     * WARNING - void declaration
     */
    public static void loadBitmap(String localPath, ImageView imageView, float targetWidth, float targetHeight) {
        String string2;
        void var3_3;
        void var2_2;
        Object[] objectArray;
        BitmapWorkerTask bitmapWorkerTask = new BitmapWorkerTask((ImageView)objectArray, (float)var2_2, (float)var3_3);
        Object[] objectArray2 = new String[1];
        objectArray = objectArray2;
        objectArray2[0] = string2;
        bitmapWorkerTask.execute(objectArray);
    }

    /*
     * WARNING - void declaration
     */
    public static void loadBitmap(@NonNull String localPath, ImageView imageView, BitmapWorkerTask.OnImageLoadedListener onImageLoadedListener) {
        String string2;
        void var2_2;
        Object[] objectArray;
        BitmapWorkerTask bitmapWorkerTask = new BitmapWorkerTask((ImageView)objectArray, (BitmapWorkerTask.OnImageLoadedListener)var2_2);
        Object[] objectArray2 = new String[1];
        objectArray = objectArray2;
        objectArray2[0] = string2;
        bitmapWorkerTask.execute(objectArray);
    }

    /*
     * WARNING - void declaration
     */
    public static void loadBitmap(String localPath, ImageView imageView, float targetWidth, float targetHeight, BitmapWorkerTask.OnImageLoadedListener onImageLoadedListener) {
        String string2;
        void var4_4;
        void var3_3;
        void var2_2;
        Object[] objectArray;
        BitmapWorkerTask bitmapWorkerTask = new BitmapWorkerTask((ImageView)objectArray, (float)var2_2, (float)var3_3, (BitmapWorkerTask.OnImageLoadedListener)var4_4);
        Object[] objectArray2 = new String[1];
        objectArray = objectArray2;
        objectArray2[0] = string2;
        bitmapWorkerTask.execute(objectArray);
    }

    public static Bitmap decodeSampledBitmapFromLocalPath(String imageFilePath) {
        String string2;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)string2, (BitmapFactory.Options)options);
        options.inSampleSize = BitmapUtils.calculateInSampleSize(options);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeFile((String)imageFilePath, (BitmapFactory.Options)options);
    }

    public static int calculateInSampleSize(BitmapFactory.Options options) {
        BitmapFactory.Options options2;
        int n2 = options.outHeight;
        int n3 = options2.outWidth;
        int n4 = 1;
        int n5 = 500;
        int n6 = 500;
        if (n2 > n5 || n3 > n6) {
            int n7 = n3;
            n3 = n2 / 2;
            n2 = n7 / 2;
            while (n3 / n4 >= n5 && n2 / n4 >= n6) {
                n4 *= 2;
            }
        }
        return n4;
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    public static Uri saveBitmapAsPNG(Bitmap bitmap, int quality, File directory, String fileNamePrefix) throws IOException {
        void var1_1;
        e e2;
        BufferedOutputStream bufferedOutputStream;
        void var3_4;
        BufferedOutputStream bufferedOutputStream2;
        File file;
        File file2 = file;
        file = new File((File)((Object)bufferedOutputStream2), (String)var3_4 + "_" + System.currentTimeMillis() + ".png");
        bufferedOutputStream2 = bufferedOutputStream;
        bufferedOutputStream2(new FileOutputStream(file2));
        e2 = BitmapUtils.compressQuietlyBitmap((Bitmap)e2, Bitmap.CompressFormat.PNG, (int)var1_1, bufferedOutputStream2);
        ((OutputStream)bufferedOutputStream).close();
        Uri uri = Uri.fromFile((File)file);
        if (!e2.a()) {
            if ((e2.b() || e2.a()) && uri != null) {
                return uri;
            }
            throw new IOException("uri is null");
        }
        throw new OutOfMemoryError();
    }

    /*
     * WARNING - void declaration
     */
    public static long getCompressedBitmapSize(Bitmap bitmap, int quality) {
        void var1_1;
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, (int)var1_1, (OutputStream)byteArrayOutputStream2);
        return byteArrayOutputStream2.size();
    }

    /*
     * WARNING - void declaration
     */
    public static void saveBitmapAsPNG(Bitmap bitmap, int quality, File directory, String fileNamePrefix, OnSaveBitmapCallback callback) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        PoolProvider.postIOTask(() -> BitmapUtils.lambda$saveBitmapAsPNG$0(bitmap, (int)var1_1, (File)var2_2, (String)var3_3, (OnSaveBitmapCallback)var4_4));
    }

    /*
     * WARNING - void declaration
     */
    public static void saveBitmap(Bitmap bitmap, Context context, OnSaveBitmapCallback callback) {
        void var2_2;
        Bitmap bitmap2;
        PoolProvider.postIOTask(() -> BitmapUtils.lambda$saveBitmap$1(context, bitmap2, (OnSaveBitmapCallback)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @WorkerThread
    public static Uri saveDrawableBitmap(Drawable drawable2, long currentTime) throws ExecutionException, InterruptedException {
        void var1_1;
        Drawable drawable3;
        if (drawable2 == null) {
            return null;
        }
        return BitmapUtils.saveDrawableIntoFile(drawable3, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private static Uri saveDrawableIntoFile(Drawable drawable2, long currentTime) throws ExecutionException, InterruptedException {
        void var1_1;
        File file;
        Drawable drawable3 = BitmapUtils.getBitmapFromDrawable(drawable2);
        if (drawable3 != null && BitmapUtils.saveBitmap(file = BitmapUtils.getIconTargetDirectory((long)var1_1), (Bitmap)drawable3)) {
            return Uri.fromFile((File)file);
        }
        return null;
    }

    @Nullable
    private static Bitmap getBitmapFromDrawable(Drawable drawable2) throws ExecutionException, InterruptedException {
        Future<Bitmap> future = BitmapUtils.drawableToResizedBitmap(drawable2);
        return future != null ? (Bitmap)future.get() : null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean saveBitmap(File file, Bitmap bitmap) {
        block14: {
            var2_6 = null;
            var3_7 = v0;
            v1 = var1_5;
            var3_7(new FileOutputStream(var0));
            try {
                var0_1 = BitmapUtils.compressQuietly((Bitmap)v1, Bitmap.CompressFormat.PNG, 100, var3_7);
            }
            catch (Throwable var0_2) {
                var2_6 = var3_7;
                break block14;
            }
            catch (IOException v2) {
                var2_6 = var3_7;
                ** GOTO lbl-1000
            }
            try {
                v0.close();
                return var0_1;
            }
            catch (IOException v3) {
                InstabugSDKLogger.e("IBG-Core", "can't close BufferedOutputStream");
            }
            return var0_1;
            catch (Throwable var0_3) {
                break block14;
            }
            catch (IOException v4) {}
lbl-1000:
            // 2 sources

            {
                InstabugSDKLogger.e("IBG-Core", "can't compress bitmap");
                if (var2_6 == null) return false;
            }
            try {
                var2_6.close();
                return false;
            }
            catch (IOException v5) {
                InstabugSDKLogger.e("IBG-Core", "can't close BufferedOutputStream");
            }
            return false;
        }
        if (var2_6 == null) throw var0_4;
        try {
            var2_6.close();
            throw var0_4;
        }
        catch (IOException v6) {
            InstabugSDKLogger.e("IBG-Core", "can't close BufferedOutputStream");
        }
        throw var0_4;
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    public static void loadBitmapForAsset(@Nullable Context context, String fileUrl, AssetEntity.AssetType type, OnBitmapReady onBitmapReady) {
        if (context != null) {
            void var3_3;
            void var2_2;
            void var1_1;
            Context context2;
            AssetsCacheManager.getAssetEntity(AssetsCacheManager.createEmptyEntity(context2, (String)var1_1, (AssetEntity.AssetType)var2_2), new AssetsCacheManager.OnDownloadFinished((OnBitmapReady)var3_3){
                final /* synthetic */ OnBitmapReady a;
                {
                    this.a = onBitmapReady;
                }

                /*
                 * WARNING - void declaration
                 */
                private static /* synthetic */ void a(AssetEntity assetEntity, OnBitmapReady onBitmapReady) {
                    void var1_1;
                    BitmapUtils.access$000(assetEntity, (OnBitmapReady)var1_1);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void onSuccess(AssetEntity assetEntity) {
                    void var1_1;
                    InstabugSDKLogger.d("IBG-Core", "Asset Entity downloaded: " + var1_1.getFile().getPath());
                    if (ThreadUtils.isCurrentThreadMain()) {
                        PoolProvider.postIOTask(() -> b.a((AssetEntity)var1_1, this.a));
                    } else {
                        BitmapUtils.access$000((AssetEntity)var1_1, this.a);
                    }
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void onFailed(Throwable error) {
                    void var1_1;
                    InstabugSDKLogger.e("IBG-Core", "Asset Entity downloading got error", (Throwable)var1_1);
                    this.a.onBitmapFailedToLoad();
                }
            });
        }
    }

    /*
     * Exception decompiling
     */
    @WorkerThread
    private static void decodeBitmap(AssetEntity assetEntity, OnBitmapReady onBitmapReady) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [5 : 41->48)] java.io.IOException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @WorkerThread
    @NonNull
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static File getIconTargetDirectory(long currentTime) {
        long l2;
        File file = (File)CoreServiceLocator.getReproScreenshotsCacheDir().getCurrentSpanDirectory();
        return new File(file, "icon_" + l2 + ".png");
    }

    @Nullable
    private static Future<Bitmap> drawableToResizedBitmap(Drawable drawable2) throws ExecutionException, InterruptedException {
        Drawable drawable3;
        Object object;
        if (drawable2 instanceof BitmapDrawable && (object = BitmapUtils.extractBitmap((BitmapDrawable)drawable3)) != null) {
            return object;
        }
        object = Instabug.getApplicationContext();
        if (object != null) {
            int n2 = DisplayUtils.dpToPxIntRounded(object.getResources(), 72);
            int n3 = drawable3.getIntrinsicWidth();
            int n4 = drawable3.getIntrinsicHeight();
            if (n3 <= n2 && n4 <= n2) {
                return BitmapUtils.createBitMap(drawable3, n3, n4);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static Future<Bitmap> createBitMap(Drawable drawable2, int intrinsicWidth, int intrinsicHeight) throws ExecutionException, InterruptedException {
        Canvas canvas;
        void var2_3;
        void var1_1;
        Drawable drawable3;
        Drawable drawable4 = drawable3;
        drawable3 = Bitmap.createBitmap((int)var1_1, (int)var2_3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas2 = canvas;
        canvas = new Canvas((Bitmap)drawable3);
        BitmapUtils.drawDrawableIntoCanvasInMainThread(BitmapUtils.getClonedDrawable(drawable4), canvas2);
        return PoolProvider.submitIOTask(() -> BitmapUtils.lambda$createBitMap$2(intrinsicWidth, (int)var2_3, (Bitmap)drawable3));
    }

    @NonNull
    private static Drawable getClonedDrawable(Drawable drawable2) {
        Drawable drawable3;
        if (drawable2.getConstantState() != null) {
            drawable3 = drawable3.getConstantState().newDrawable();
        }
        return drawable3;
    }

    @Nullable
    private static FutureTask<Bitmap> extractBitmap(BitmapDrawable drawable2) {
        BitmapDrawable bitmapDrawable = drawable2.getBitmap();
        if (bitmapDrawable != null) {
            FutureTask<Bitmap> futureTask = new FutureTask<Bitmap>(() -> BitmapUtils.lambda$extractBitmap$3((Bitmap)bitmapDrawable));
            futureTask.run();
            return futureTask;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static void drawDrawableIntoCanvasInMainThread(Drawable clonedDrawable, Canvas canvas) throws ExecutionException, InterruptedException {
        void var1_1;
        PoolProvider.submitMainThreadTask(() -> BitmapUtils.lambda$drawDrawableIntoCanvasInMainThread$4(clonedDrawable, (Canvas)var1_1)).get();
    }

    public static Bitmap drawableToBitmap(Drawable drawable2) {
        Canvas canvas;
        Drawable drawable3;
        BitmapDrawable bitmapDrawable;
        if (drawable2 instanceof BitmapDrawable && (bitmapDrawable = (BitmapDrawable)drawable3).getBitmap() != null) {
            return bitmapDrawable.getBitmap();
        }
        int n2 = drawable3.getIntrinsicWidth();
        int n3 = drawable3.getIntrinsicHeight();
        if (n2 <= 0 || n3 <= 0) {
            n2 = n3 = 1;
        }
        Bitmap bitmap = Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Drawable drawable4 = drawable3;
        drawable3 = canvas;
        int n4 = new Canvas(bitmap).getWidth();
        n3 = drawable3.getHeight();
        drawable4.setBounds(0, 0, n4, n3);
        drawable4.draw((Canvas)drawable3);
        return bitmap;
    }

    /*
     * WARNING - void declaration
     */
    private static float[] getTargetDimensions(int realWidth, int realHeight) {
        void var1_1;
        int n2;
        float f2 = 24.0f;
        float[] fArray = new float[2];
        float[] fArray2 = fArray;
        fArray[0] = f2;
        fArray[1] = f2;
        if (realHeight > n2) {
            fArray2[0] = (float)n2 / (float)var1_1 * f2;
        } else if (var1_1 < n2) {
            fArray2[1] = (float)var1_1 / (float)n2 * f2;
        }
        return fArray2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static Bitmap resizeBitmap(Bitmap bitmap, float targetWidth, float targetHeight) {
        Paint paint;
        Matrix matrix;
        Canvas canvas;
        Bitmap bitmap2;
        void var2_3;
        void var1_1;
        if (bitmap == null) {
            return null;
        }
        if (var1_1 == 0.0f && var2_3 == 0.0f) {
            return bitmap2;
        }
        Bitmap bitmap3 = Bitmap.createBitmap((int)((int)var1_1), (int)((int)var2_3), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        if (bitmap2.getWidth() < bitmap2.getHeight() && var1_1 > var2_3) {
            return bitmap2;
        }
        if (bitmap2.getWidth() > bitmap2.getHeight() && var1_1 < var2_3) {
            return bitmap2;
        }
        Canvas canvas2 = canvas;
        canvas = new Canvas(bitmap3);
        Matrix matrix2 = matrix;
        matrix = new Matrix();
        if (bitmap2.getWidth() < bitmap2.getHeight()) {
            matrix2.setScale((float)(var1_1 /= (float)bitmap2.getWidth()), (float)(var2_3 / (float)bitmap2.getHeight()));
        } else {
            void v2 = var1_1;
            var1_1 = var2_3 / (float)bitmap2.getHeight();
            matrix2.setScale((float)var1_1, (float)(v2 / (float)bitmap2.getWidth()));
        }
        Paint paint2 = paint;
        paint = new Paint();
        canvas2.drawBitmap(bitmap2, matrix2, paint2);
        return bitmap3;
    }

    /*
     * WARNING - void declaration
     */
    public static void saveBitmap(Bitmap bitmap, Uri imageUri, Context context, OnSaveBitmapCallback callback) {
        if (imageUri.getPath() != null) {
            void var3_3;
            Bitmap bitmap2;
            void var2_2;
            void var1_1;
            PoolProvider.postIOTask(() -> BitmapUtils.lambda$saveBitmap$5((Uri)var1_1, (Context)var2_2, bitmap2, (OnSaveBitmapCallback)var3_3));
        }
    }

    @WorkerThread
    public static Bitmap decryptBitmap(String path) {
        Object object = InstabugCore.decryptOnTheFly(path);
        if (((ProcessedBytes)object).isProcessSuccessful()) {
            byte[] byArray = ((ProcessedBytes)object).getFileBytes();
            return BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
        }
        object = Bitmap.Config.ARGB_8888;
        return Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)object);
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    public static boolean compressQuietly(@NonNull Bitmap bitmap, @NonNull Bitmap.CompressFormat format, @IntRange(from=0L, to=100L) int quality, @NonNull OutputStream outputStream) {
        Exception exception2;
        block5: {
            boolean bl;
            block4: {
                block3: {
                    void var3_4;
                    void var2_3;
                    void var1_2;
                    Bitmap bitmap2;
                    try {
                        if (bitmap.isRecycled()) break block3;
                    }
                    catch (Exception exception2) {
                        break block5;
                    }
                    if (!bitmap2.compress((Bitmap.CompressFormat)var1_2, (int)var2_3, (OutputStream)var3_4)) break block3;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
            return bl;
        }
        InstabugSDKLogger.e("IBG-Core", "Error while compressing bitmap " + exception2.getMessage());
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    public static e compressQuietlyBitmap(@NonNull Bitmap bitmap, @NonNull Bitmap.CompressFormat format, @IntRange(from=0L, to=100L) int quality, @NonNull OutputStream outputStream) {
        OutOfMemoryError outOfMemoryError2;
        block7: {
            block5: {
                void var3_5;
                void var2_4;
                void var1_3;
                Bitmap bitmap2;
                if (bitmap.isRecycled()) break block5;
                if (!bitmap2.compress((Bitmap.CompressFormat)var1_3, (int)var2_4, (OutputStream)var3_5)) break block5;
                try {
                    return new e(true, false);
                }
                catch (Exception exception) {
                }
                catch (OutOfMemoryError outOfMemoryError2) {
                    break block7;
                }
                InstabugSDKLogger.e("IBG-Core", "Error while compressing bitmap " + exception.getMessage());
            }
            return new e(false, false);
        }
        InstabugSDKLogger.e("IBG-Core", "Error while compressing bitmap due to low memory " + outOfMemoryError2.getMessage());
        return new e(false, true);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static /* synthetic */ void lambda$saveBitmap$5(Uri imageUri, Context context, Bitmap bitmap, OnSaveBitmapCallback callback) {
        void var2_4;
        Uri uri;
        OutputStream outputStream;
        if (imageUri.getPath() == null) return;
        void v02 = outputStream;
        uri = Uri.fromFile((File)new File(uri.getPath()));
        outputStream = v02.getContentResolver().openOutputStream(uri);
        if (outputStream == null) return;
        final boolean bl = BitmapUtils.compressQuietly((Bitmap)var2_4, Bitmap.CompressFormat.PNG, 100, outputStream);
        try {
            void var3_5;
            new Handler(Looper.getMainLooper()).post(new Runnable((OnSaveBitmapCallback)var3_5, uri){
                final /* synthetic */ OnSaveBitmapCallback b;
                final /* synthetic */ Uri c;
                {
                    this.b = onSaveBitmapCallback;
                    this.c = uri;
                }

                @Override
                public void run() {
                    OnSaveBitmapCallback onSaveBitmapCallback;
                    if (bl && (onSaveBitmapCallback = this.b) != null) {
                        onSaveBitmapCallback.onSuccess(this.c);
                    }
                }
            });
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (fileNotFoundException.getMessage() == null) return;
            InstabugSDKLogger.e("IBG-Core", "Error while saving bitmap: " + fileNotFoundException.getMessage());
        }
        return;
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ Canvas lambda$drawDrawableIntoCanvasInMainThread$4(Drawable clonedDrawable, Canvas canvas) throws Exception {
        void var1_2;
        Drawable drawable2;
        Drawable drawable3 = drawable2;
        void v12 = var1_2;
        int n2 = v12.getWidth();
        int n3 = v12.getHeight();
        drawable3.setBounds(0, 0, n2, n3);
        drawable3.draw((Canvas)var1_2);
        return canvas;
    }

    private static /* synthetic */ Bitmap lambda$extractBitmap$3(Bitmap originalBitmap) throws Exception {
        return BitmapUtils.resizeBitmap(originalBitmap, 24.0f, 24.0f);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ Bitmap lambda$createBitMap$2(int intrinsicWidth, int intrinsicHeight, Bitmap bitmap) throws Exception {
        void var1_2;
        int n2;
        float[] fArray = BitmapUtils.getTargetDimensions(n2, (int)var1_2);
        float f2 = fArray[0];
        return BitmapUtils.resizeBitmap(bitmap, f2, fArray[1]);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$saveBitmap$1(Context context, Bitmap bitmap, OnSaveBitmapCallback callback) {
        void var2_4;
        Uri uri;
        BufferedOutputStream bufferedOutputStream;
        FileOutputStream fileOutputStream;
        File file;
        Object object = DiskUtils.getInstabugInternalDirectory(context);
        Object object2 = file;
        file = new File((File)object, "bug_" + System.currentTimeMillis() + "_.jpg");
        object = fileOutputStream;
        fileOutputStream = new FileOutputStream((File)object2);
        object2 = bufferedOutputStream;
        ((BufferedOutputStream)object2)((OutputStream)object);
        final boolean bl = BitmapUtils.compressQuietly((Bitmap)uri, Bitmap.CompressFormat.JPEG, 100, (OutputStream)object2);
        ((OutputStream)bufferedOutputStream).close();
        uri = Uri.fromFile((File)file);
        try {
            new Handler(Looper.getMainLooper()).post(new Runnable((OnSaveBitmapCallback)var2_4){
                final /* synthetic */ OnSaveBitmapCallback c;
                {
                    this.c = onSaveBitmapCallback;
                }

                @Override
                public void run() {
                    Uri uri2;
                    if (bl && (uri2 = uri) != null) {
                        this.c.onSuccess(uri2);
                    } else {
                        this.c.onError(new Throwable("Uri equal null"));
                    }
                }
            });
        }
        catch (IOException iOException) {
            var2_4.onError(iOException);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$saveBitmapAsPNG$0(Bitmap bitmap, int quality, File directory, String fileNamePrefix, OnSaveBitmapCallback callback) {
        try {
            void var3_4;
            void var2_3;
            void var1_2;
            Bitmap bitmap2;
            callback.onSuccess(BitmapUtils.saveBitmapAsPNG(bitmap2, (int)var1_2, (File)var2_3, (String)var3_4));
        }
        catch (IOException iOException) {
            void var4_5;
            var4_5.onError(iOException);
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(AssetEntity x02, OnBitmapReady x12) {
        void var1_1;
        BitmapUtils.decodeBitmap(x02, (OnBitmapReady)var1_1);
    }

    @Keep
    public static interface OnBitmapReady {
        public void onBitmapReady(@Nullable Bitmap var1);

        public void onBitmapFailedToLoad();
    }

    public static interface OnSaveBitmapCallback {
        public void onSuccess(Uri var1);

        public void onError(Throwable var1);
    }
}

