/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.widget.TextView;
import com.instabug.library.util.DrawingUtility;

public class BubbleTextView
extends TextView {
    private static final float ARROW_LENGTH_DP = 7.0f;
    private RectF rectF;
    private Paint paint;
    private float arrowLengthPx;
    private PointF arrowSidePoint;
    private PointF arrowTopPoint;
    private PointF arrowBottomPoint;
    private Path arrowPath;
    private float cornerRadius;

    /*
     * WARNING - void declaration
     */
    public BubbleTextView(Context context) {
        void var1_1;
        BubbleTextView bubbleTextView = this;
        super((Context)var1_1);
        bubbleTextView.init();
    }

    /*
     * WARNING - void declaration
     */
    public BubbleTextView(Context context, AttributeSet attrs) {
        void var2_2;
        void var1_1;
        BubbleTextView bubbleTextView = this;
        super((Context)var1_1, (AttributeSet)var2_2);
        bubbleTextView.init();
    }

    /*
     * WARNING - void declaration
     */
    public BubbleTextView(Context context, AttributeSet attrs, int defStyle) {
        void var3_3;
        void var2_2;
        void var1_1;
        BubbleTextView bubbleTextView = this;
        super((Context)var1_1, (AttributeSet)var2_2, (int)var3_3);
        bubbleTextView.init();
    }

    private void init() {
        float f2;
        BubbleTextView bubbleTextView = this;
        bubbleTextView.setTextColor(-1);
        bubbleTextView.rectF = new RectF();
        this.paint = new Paint(1);
        this.paint.setColor(-12303292);
        bubbleTextView.paint.setStyle(Paint.Style.FILL);
        DisplayMetrics displayMetrics = bubbleTextView.getContext().getResources().getDisplayMetrics();
        this.arrowLengthPx = f2 = TypedValue.applyDimension((int)1, (float)7.0f, (DisplayMetrics)displayMetrics);
        this.cornerRadius = f2 / 2.0f;
        int n2 = (int)f2;
        bubbleTextView.setPadding((int)((double)f2 * 1.5), n2, (int)((double)f2 * 1.5 + (double)f2), n2);
        bubbleTextView.arrowSidePoint = new PointF();
        bubbleTextView.arrowTopPoint = new PointF();
        bubbleTextView.arrowBottomPoint = new PointF();
        bubbleTextView.arrowPath = new Path();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int n2;
        int n3;
        BubbleTextView bubbleTextView = this;
        super.onMeasure(n3, n2);
        n3 = bubbleTextView.getMeasuredHeight();
        n2 = bubbleTextView.getMeasuredWidth();
        bubbleTextView.setMeasuredDimension(n2, n3);
        RectF rectF = bubbleTextView.rectF;
        float f2 = n2;
        rectF.right = f2 - this.arrowLengthPx;
        bubbleTextView.rectF.bottom = n3;
        PointF pointF = bubbleTextView.arrowSidePoint;
        pointF.x = f2;
        pointF.y = rectF.centerY();
        f2 = (float)((double)bubbleTextView.arrowLengthPx / Math.cos(45.0));
        BubbleTextView bubbleTextView2 = this;
        BubbleTextView bubbleTextView3 = this;
        PointF pointF2 = bubbleTextView3.arrowSidePoint;
        PointF pointF3 = bubbleTextView3.arrowTopPoint;
        DrawingUtility.pointOnCircle(f2, 225.0f, pointF2, pointF3);
        pointF2 = bubbleTextView2.arrowSidePoint;
        pointF3 = bubbleTextView2.arrowBottomPoint;
        DrawingUtility.pointOnCircle(f2, 135.0f, pointF2, pointF3);
        PointF pointF4 = this.arrowTopPoint;
        float f3 = pointF4.x;
        bubbleTextView.arrowPath.moveTo(f3, pointF4.y);
        PointF pointF5 = this.arrowSidePoint;
        f3 = pointF5.x;
        bubbleTextView.arrowPath.lineTo(f3, pointF5.y);
        PointF pointF6 = this.arrowBottomPoint;
        float f4 = pointF6.x;
        bubbleTextView.arrowPath.lineTo(f4, pointF6.y);
        bubbleTextView.arrowPath.close();
    }

    /*
     * WARNING - void declaration
     */
    protected void onDraw(Canvas canvas) {
        void var1_1;
        BubbleTextView bubbleTextView = this_;
        BubbleTextView bubbleTextView2 = this_;
        BubbleTextView bubbleTextView3 = this_;
        BubbleTextView this_ = bubbleTextView3.rectF;
        float f2 = bubbleTextView3.cornerRadius;
        Paint paint = bubbleTextView3.paint;
        float f3 = f2;
        var1_1.drawRoundRect((RectF)this_, f3, f3, paint);
        this_ = bubbleTextView2.arrowPath;
        var1_1.drawPath((Path)this_, bubbleTextView2.paint);
        super.onDraw((Canvas)var1_1);
    }
}

