/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.core.content.ContextCompat;
import com.instabug.library.Feature;
import com.instabug.library.InstabugColorTheme;
import com.instabug.library.InstabugCustomTextPlaceHolder;
import com.instabug.library.InstabugState;
import com.instabug.library.InstabugStateProvider;
import com.instabug.library.MaskingType;
import com.instabug.library.OnUserUUIDReadyCallback;
import com.instabug.library.Platform;
import com.instabug.library.ReproConfigurations;
import com.instabug.library.apichecker.APIChecker;
import com.instabug.library.apichecker.ReturnableRunnable;
import com.instabug.library.apichecker.VoidRunnable;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.coreeventbus.IBGCoreEventPublisher;
import com.instabug.library.core.eventbus.coreeventbus.IBGSdkCoreEvent;
import com.instabug.library.diagnostics.customtraces.IBGPendingTraceHandler;
import com.instabug.library.featuresflags.model.IBGFeatureFlag;
import com.instabug.library.h;
import com.instabug.library.internal.contentprovider.InstabugApplicationProvider;
import com.instabug.library.internal.servicelocator.CoreServiceLocator;
import com.instabug.library.internal.video.customencoding.VideoEncoderConfig;
import com.instabug.library.invocation.InstabugInvocationEvent;
import com.instabug.library.invocation.InvocationManagerContract;
import com.instabug.library.logging.InstabugUserEventLogger;
import com.instabug.library.model.IBGTheme;
import com.instabug.library.model.Report;
import com.instabug.library.networkDiagnostics.model.NetworkDiagnosticsCallback;
import com.instabug.library.networkinterception.NetworkInterceptionServiceLocator;
import com.instabug.library.screenshot.c;
import com.instabug.library.sessionV3.di.a;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.ui.onboarding.WelcomeMessage;
import com.instabug.library.user.UserEventParam;
import com.instabug.library.user.e;
import com.instabug.library.util.BitmapUtils;
import com.instabug.library.util.InstabugDeprecationLogger;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.StringUtility;
import com.instabug.library.util.TimeUtils;
import com.instabug.library.util.b;
import com.instabug.library.util.d;
import com.instabug.library.util.threading.PoolProvider;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;

public class Instabug {
    @Nullable
    private static volatile Instabug INSTANCE;
    private static Context appContext;
    static final String REFLECTION_ERROR_MESSAGE = "something went wrong while calling by reflection class not found ";
    private final com.instabug.library.c delegate;

    /*
     * WARNING - void declaration
     */
    private Instabug(@NonNull com.instabug.library.c delegate) {
        void var1_1;
        this.delegate = var1_1;
    }

    private static void setNetworkDiagnosticsCallback(@NonNull NetworkDiagnosticsCallback callback) {
        APIChecker.checkAndRunInExecutor("setNetworkDiagnosticsCallback", () -> {
            if (callback != null) {
                NetworkDiagnosticsCallback networkDiagnosticsCallback;
                CoreServiceLocator.getNetworkDiagnosticsManager().a(networkDiagnosticsCallback);
            }
        });
    }

    public static void setSdkDebugLogsLevel(int level) {
        APIChecker.checkAndRunInExecutor("setSdkDebugLogsLevel", () -> {
            int n2;
            SettingsManager.getInstance().setLogLevel(n2);
        });
    }

    @SuppressLint(value={"ERADICATE_NULLABLE_DEREFERENCE"})
    public static int getPrimaryColor() {
        Integer n2 = 0;
        return APIChecker.checkAndGet("Instabug.getPrimaryColor", () -> SettingsManager.getInstance().getPrimaryColor(), n2);
    }

    @Deprecated
    public static void setPrimaryColor(@ColorInt int primaryColorValue) {
        int n2;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                SettingsManager.getInstance().setPrimaryColor(n2);
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.setPrimaryColor", voidRunnable2);
    }

    @Nullable
    @SuppressLint(value={"ERADICATE_NULLABLE_DEREFERENCE"})
    public static InstabugColorTheme getTheme() {
        ReturnableRunnable returnableRunnable;
        ReturnableRunnable returnableRunnable2 = returnableRunnable;
        returnableRunnable = new ReturnableRunnable(){

            public InstabugColorTheme run() {
                return SettingsManager.getInstance().getTheme();
            }
        };
        InstabugColorTheme instabugColorTheme = InstabugColorTheme.InstabugColorThemeLight;
        return APIChecker.checkAndGet("Instabug.getTheme", returnableRunnable2, instabugColorTheme);
    }

    /*
     * WARNING - void declaration
     */
    public static void addFileAttachment(@NonNull Uri fileUri, @NonNull String fileNameWithExtension) {
        void var1_1;
        Uri uri;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable((String)var1_1){
            final /* synthetic */ String b;
            {
                this.b = string;
            }

            @Override
            public void run() {
                if (uri == null) {
                    InstabugSDKLogger.w("IBG-Core", "fileUri object passed to Instabug.addFileAttachment() is null");
                    return;
                }
                if (this.b == null) {
                    InstabugSDKLogger.w("IBG-Core", "fileNameWithExtension passed to Instabug.addFileAttachment() is null");
                    return;
                }
                E e2 = this;
                Uri uri2 = e2.uri;
                SettingsManager.getInstance().addExtraAttachmentFile(uri2, e2.b);
                InstabugSDKLogger.d("IBG-Core", "addFileAttachment file uri: " + uri);
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.addFileAttachment", voidRunnable2);
    }

    /*
     * WARNING - void declaration
     */
    public static void addFileAttachment(@NonNull byte[] data, @NonNull String fileNameWithExtension) {
        void var1_1;
        byte[] byArray;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable((String)var1_1){
            final /* synthetic */ String b;
            {
                this.b = string;
            }

            @Override
            public void run() {
                if (this_.byArray == null) {
                    InstabugSDKLogger.w("IBG-Core", "data object passed to Instabug.addFileAttachment() is null");
                    return;
                }
                if (this_.b == null) {
                    InstabugSDKLogger.w("IBG-Core", "fileNameWithExtension  passed to Instabug.addFileAttachment() is null");
                    return;
                }
                F f2 = this_;
                Object this_ = f2.byArray;
                SettingsManager.getInstance().addExtraAttachmentFile((byte[])this_, f2.b);
                InstabugSDKLogger.d("IBG-Core", "addFileAttachment bytes");
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.addFileAttachment", voidRunnable2);
    }

    public static void clearFileAttachment() {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                SettingsManager.getInstance().clearExtraAttachmentFiles();
                InstabugSDKLogger.d("IBG-Core", "clearFileAttachment");
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.clearFileAttachment", voidRunnable2);
    }

    @SuppressLint(value={"ERADICATE_RETURN_NOT_NULLABLE"})
    public static String getUserData() {
        ReturnableRunnable returnableRunnable;
        ReturnableRunnable returnableRunnable2 = returnableRunnable;
        returnableRunnable = new ReturnableRunnable(){

            public String run() {
                return SettingsManager.getInstance().getUserData();
            }
        };
        return APIChecker.checkAndGet("Instabug.getUserData", returnableRunnable2, "");
    }

    public static void setUserData(@NonNull String userData) {
        String string;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (com.instabug.library.d.d().b((Object)"USER_DATA") == Feature.State.ENABLED) {
                    SettingsManager.getInstance().setUserData(StringUtility.trimString(string, 1000));
                }
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.setUserData", voidRunnable2);
    }

    @SuppressLint(value={"ERADICATE_RETURN_NOT_NULLABLE"})
    public static String getUserEmail() {
        ReturnableRunnable returnableRunnable;
        ReturnableRunnable returnableRunnable2 = returnableRunnable;
        returnableRunnable = new ReturnableRunnable(){

            public String run() {
                return e.f();
            }
        };
        return APIChecker.checkAndGet("Instabug.getUserEmail", returnableRunnable2, "");
    }

    public static void getUserUUID(@NonNull OnUserUUIDReadyCallback callback) {
        APIChecker.checkAndRunInExecutor("Instabug.getUserUUID", () -> PoolProvider.postMainThreadTask(() -> Instabug.lambda$getUserUUID$3(callback, e.i())));
    }

    @Nullable
    @SuppressLint(value={"ERADICATE_RETURN_NOT_NULLABLE"})
    public static String getAppToken() {
        return SettingsManager.getInstance().getAppToken();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static void identifyUser(@Nullable String username, @NonNull String email) {
        void var1_1;
        APIChecker.checkAndRunInExecutor("Instabug.identifyUser", () -> Instabug.lambda$identifyUser$5(username, (String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static void identifyUser(@Nullable String userName, @Nullable String email, @Nullable String id2) {
        void var2_2;
        void var1_1;
        APIChecker.checkAndRunInExecutor("Instabug.identifyUser", () -> Instabug.lambda$identifyUser$6(userName, (String)var1_1, (String)var2_2));
    }

    @Nullable
    public static Context getApplicationContext() {
        Object object = appContext;
        if (object != null) {
            return object;
        }
        object = InstabugApplicationProvider.getInstance();
        if (object != null) {
            return ((InstabugApplicationProvider)object).getApplication();
        }
        return null;
    }

    @Nullable
    private static Instabug getInstance() {
        Object object = InstabugApplicationProvider.getInstance();
        if (INSTANCE == null && object != null) {
            object = com.instabug.library.c.a(((InstabugApplicationProvider)object).getApplication());
            INSTANCE = new Instabug((com.instabug.library.c)object);
        }
        return INSTANCE;
    }

    public static void logoutUser() {
        APIChecker.checkAndRunInExecutor("Instabug.logoutUser", () -> {
            e.a(true);
            InstabugSDKLogger.d("IBG-Core", "logoutUser");
        });
    }

    public static boolean isBuilt() {
        return INSTANCE != null && InstabugStateProvider.getInstance().getState() != InstabugState.NOT_BUILT && InstabugStateProvider.getInstance().getState() != InstabugState.BUILDING;
    }

    public static boolean isEnabled() {
        if (!Instabug.isBuilt()) {
            return false;
        }
        return com.instabug.library.d.d().c((Object)"INSTABUG") && com.instabug.library.d.d().b((Object)"INSTABUG") == Feature.State.ENABLED;
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static synchronized void enable() {
        if (com.instabug.library.internal.utils.memory.a.a()) {
            return;
        }
        PoolProvider.getApiExecutor().execute(new Runnable(){

            @Override
            public void run() {
                VoidRunnable voidRunnable;
                VoidRunnable voidRunnable2 = voidRunnable;
                voidRunnable = new VoidRunnable(this){
                    final /* synthetic */ K a;
                    {
                        void var1_1;
                        this.a = var1_1;
                    }

                    @Override
                    public void run() {
                        Instabug instabug = Instabug.getInstance();
                        if (instabug != null) {
                            Instabug instabug2 = instabug;
                            instabug2.delegate.c(Feature.State.ENABLED);
                            instabug2.delegate.a(InstabugState.ENABLED);
                            instabug2.delegate.N();
                        }
                        InstabugSDKLogger.d("IBG-Core", "enable");
                    }
                };
                APIChecker.checkBuilt("Instabug.enable", voidRunnable2);
            }
        });
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static synchronized void disable() {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (Instabug.getInstance() != null) {
                    Instabug.getInstance().delegate.S();
                }
                InstabugSDKLogger.d("IBG-Core", "disable");
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.disable", voidRunnable2);
    }

    public static void pauseSdk() {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (Instabug.getInstance() != null) {
                    Instabug.getInstance().delegate.A();
                }
                InstabugSDKLogger.d("IBG-Core", "pauseSdk");
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.pauseSdk", voidRunnable2);
    }

    public static void resumeSdk() {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (Instabug.getInstance() != null) {
                    Instabug.getInstance().delegate.I();
                }
                InstabugSDKLogger.d("IBG-Core", "resumeSdk");
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.resumeSdk", voidRunnable2);
    }

    public static void setLocale(@NonNull Locale locale) {
        Locale locale2;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (locale2 == null) {
                    InstabugSDKLogger.w("IBG-Core", "locale object passed to Instabug.setLocale is null");
                    return;
                }
                if (Instabug.getInstance() != null) {
                    Instabug.getInstance().delegate.a(locale2);
                }
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.setLocale", voidRunnable2);
    }

    @SuppressLint(value={"ERADICATE_RETURN_NOT_NULLABLE"})
    public static Locale getLocale(@Nullable Context context) {
        Object object;
        ReturnableRunnable returnableRunnable;
        ReturnableRunnable returnableRunnable2 = returnableRunnable;
        returnableRunnable = new ReturnableRunnable((Context)object){
            final /* synthetic */ Context a;
            {
                this.a = context;
            }

            public Locale run() {
                return SettingsManager.getInstance().getInstabugLocale(this.a);
            }
        };
        object = Locale.getDefault();
        return (Locale)APIChecker.checkAndGet("Instabug.getLocale", returnableRunnable2, object);
    }

    public static void addTags(String ... tags) {
        String[] stringArray;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                SettingsManager.getInstance().addTags(StringUtility.trimStrings(stringArray));
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.addTags", voidRunnable2);
    }

    @Nullable
    @SuppressLint(value={"ERADICATE_RETURN_NOT_NULLABLE"})
    public static ArrayList<String> getTags() {
        ReturnableRunnable returnableRunnable;
        ReturnableRunnable returnableRunnable2 = returnableRunnable;
        returnableRunnable = new ReturnableRunnable(){

            public ArrayList run() {
                return SettingsManager.getInstance().getTags();
            }
        };
        return APIChecker.checkAndGet("Instabug.getTags", returnableRunnable2, null);
    }

    public static void resetTags() {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                SettingsManager.getInstance().resetTags();
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.resetTags", voidRunnable2);
    }

    public static void setCustomTextPlaceHolders(@NonNull InstabugCustomTextPlaceHolder instabugCustomTextPlaceHolder) {
        InstabugCustomTextPlaceHolder instabugCustomTextPlaceHolder2;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (instabugCustomTextPlaceHolder2 == null) {
                    InstabugSDKLogger.w("IBG-Core", "instabugCustomTextPlaceHolder object passed to Instabug.setCustomTextPlaceHolders() is null");
                    return;
                }
                SettingsManager.getInstance().setCustomPlaceHolders(instabugCustomTextPlaceHolder2);
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.setCustomTextPlaceHolders", voidRunnable2);
    }

    @Nullable
    public static HashMap<String, String> getAllUserAttributes() {
        ReturnableRunnable returnableRunnable;
        ReturnableRunnable returnableRunnable2 = returnableRunnable;
        returnableRunnable = new ReturnableRunnable(){

            public HashMap run() {
                if (Instabug.getInstance() != null) {
                    return Instabug.getInstance().delegate.j();
                }
                return new HashMap();
            }
        };
        return APIChecker.checkAndGet("Instabug.getAllUserAttributes", returnableRunnable2, null);
    }

    /*
     * WARNING - void declaration
     */
    public static void setUserAttribute(@NonNull String key, @NonNull String value) {
        void var1_1;
        String string;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable((String)var1_1){
            final /* synthetic */ String b;
            {
                this.b = string2;
            }

            @Override
            public void run() {
                if (Instabug.getInstance() != null) {
                    l l2 = string2;
                    String string2 = l2.string;
                    Instabug.getInstance().delegate.a(string2, l2.b);
                }
                InstabugSDKLogger.d("IBG-Core", "setUserAttribute");
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.setUserAttribute", voidRunnable2);
    }

    @Nullable
    @SuppressLint(value={"ERADICATE_RETURN_NOT_NULLABLE"})
    public static String getUserAttribute(@NonNull String key) {
        String string;
        ReturnableRunnable returnableRunnable;
        ReturnableRunnable returnableRunnable2 = returnableRunnable;
        returnableRunnable = new ReturnableRunnable(){

            public String run() {
                if (Instabug.getInstance() != null) {
                    return Instabug.getInstance().delegate.a(string);
                }
                return null;
            }
        };
        return APIChecker.checkAndGet("Instabug.getUserAttribute", returnableRunnable2, null);
    }

    public static void removeUserAttribute(@NonNull String key) {
        String string;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (Instabug.getInstance() != null) {
                    Instabug.getInstance().delegate.c(string);
                }
                InstabugSDKLogger.d("IBG-Core", "removeUserAttribute");
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.removeUserAttribute", voidRunnable2);
    }

    public static void clearAllUserAttributes() {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (Instabug.getInstance() != null) {
                    Instabug.getInstance().delegate.e();
                }
                InstabugSDKLogger.d("IBG-Core", "clearAllUserAttributes");
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.clearAllUserAttributes", voidRunnable2);
    }

    public static Date getFirstRunAt() {
        return SettingsManager.getInstance().getFirstRunAt();
    }

    public static boolean isAppOnForeground() {
        return SettingsManager.getInstance().isAppOnForeground();
    }

    public static void setWelcomeMessageState(@NonNull WelcomeMessage.State welcomeMessageState) {
        APIChecker.checkAndRunInExecutor("Instabug.setWelcomeMessageState", () -> {
            WelcomeMessage.State state;
            if (welcomeMessageState == null) {
                InstabugSDKLogger.w("IBG-Core", "welcomeMessageState object passed to Instabug.setWelcomeMessageState() is null");
                return;
            }
            PoolProvider.postIOTaskWithCheck(() -> {
                int n2 = com.instabug.library.ui.onboarding.utils.a.a(state);
                Object object = "com.instabug.bug.BugReporting";
                Method method = Class.forName("com.instabug.bug.BugReporting").getDeclaredMethod("setWelcomeMessageState", Integer.TYPE);
                int n3 = n2;
                ((AccessibleObject)method).setAccessible(true);
                Class<?> clazz = Class.forName((String)object);
                object = n3;
                method.invoke(clazz, object);
                try {
                    ((AccessibleObject)method).setAccessible(false);
                }
                catch (Exception exception) {
                    InstabugSDKLogger.e("IBG-Core", REFLECTION_ERROR_MESSAGE + exception.getMessage());
                }
            });
        });
    }

    public static void showWelcomeMessage(@NonNull WelcomeMessage.State welcomeMessageState) {
        APIChecker.checkAndRunInExecutor("Instabug.showWelcomeMessage", () -> {
            WelcomeMessage.State state;
            if (welcomeMessageState == null) {
                InstabugSDKLogger.w("IBG-Core", "welcomeMessageState object passed to Instabug.showWelcomeMessage() is null");
                return;
            }
            if (!InstabugCore.isForegroundBusy()) {
                int n2 = com.instabug.library.ui.onboarding.utils.a.a(state);
                Object object = "com.instabug.bug.BugReporting";
                Method method = Class.forName("com.instabug.bug.BugReporting").getDeclaredMethod("showWelcomeMessage", Integer.TYPE);
                int n3 = n2;
                ((AccessibleObject)method).setAccessible(true);
                Class<?> clazz = Class.forName((String)object);
                object = n3;
                method.invoke(clazz, object);
                try {
                    ((AccessibleObject)method).setAccessible(false);
                }
                catch (Exception exception) {
                    InstabugSDKLogger.e("IBG-Core", REFLECTION_ERROR_MESSAGE + exception.getMessage());
                }
            }
            InstabugSDKLogger.i("IBG-Core", "showWelcomeMessage: " + state.name());
        });
    }

    public static void setSessionProfilerState(@NonNull Feature.State state) {
        Feature.State state2;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (state2 == null) {
                    InstabugSDKLogger.w("IBG-Core", "state object passed to Instabug.setSessionProfilerState() is null");
                    return;
                }
                if (Instabug.getInstance() != null) {
                    Instabug.getInstance().delegate.b(state2);
                }
                InstabugSDKLogger.d("IBG-Core", "setSessionProfilerState: " + state2.name());
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.setSessionProfilerState", voidRunnable2);
    }

    public static void setTrackingUserStepsState(@NonNull Feature.State state) {
        Feature.State state2;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (state2 == null) {
                    InstabugSDKLogger.w("IBG-Core", "state object passed to Instabug.setTrackingUserStepsState() is null");
                    return;
                }
                com.instabug.library.d.d().a("TRACK_USER_STEPS", state2);
                InstabugSDKLogger.d("IBG-Core", "setTrackingUserStepsState: " + state2.name());
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.setTrackingUserStepsState", voidRunnable2);
    }

    public static void setReproConfigurations(ReproConfigurations configurations) {
        APIChecker.checkAndRunInExecutor("Instabug.setReproConfigurations", () -> Instabug.updateAndBroadcastReproConfigurations(configurations));
    }

    public static void setColorTheme(@NonNull InstabugColorTheme instabugTheme) {
        InstabugColorTheme instabugColorTheme;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                SettingsManager.getInstance().setTheme(instabugColorTheme);
                int n2 = D.a[instabugColorTheme.ordinal()];
                if (n2 != 1) {
                    if (n2 == 2) {
                        SettingsManager.getInstance().setPrimaryColor(-15893761);
                        SettingsManager.getInstance().setStatusBarColor(-3815737);
                    }
                } else {
                    SettingsManager.getInstance().setPrimaryColor(-9580554);
                    SettingsManager.getInstance().setStatusBarColor(-16119286);
                }
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.setColorTheme", voidRunnable2);
    }

    /*
     * WARNING - void declaration
     */
    public static void setCustomBrandingImage(@DrawableRes int lightLogoVariant, @DrawableRes int darkLogoVariant) {
        void var1_1;
        APIChecker.checkAndRunInExecutor("Instabug.setCustomBrandingImage", () -> Instabug.lambda$setCustomBrandingImage$12(lightLogoVariant, (int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private static void setCustomBrandingImage(Bitmap lightLogoVariant, Bitmap darkLogoVariant) {
        void var1_1;
        APIChecker.checkAndRunInExecutor("Instabug.setCustomBrandingImage", () -> Instabug.lambda$setCustomBrandingImage$13(lightLogoVariant, (Bitmap)var1_1));
    }

    public static void logUserEvent(@NonNull String eventIdentifier) {
        String string;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                InstabugUserEventLogger.getInstance().logUserEvent(string, new UserEventParam[0]);
                InstabugSDKLogger.d("IBG-Core", "logUserEvent: " + string);
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.logUserEvent", voidRunnable2);
    }

    public static void onReportSubmitHandler(Report.OnReportCreatedListener listener) {
        Report.OnReportCreatedListener onReportCreatedListener;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                SettingsManager.getInstance().setOnReportCreatedListener(onReportCreatedListener);
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.onReportSubmitHandler", voidRunnable2);
    }

    @VisibleForTesting
    static void setAutoScreenRecordingAudioCapturingEnabled(Feature.State isASRAudioEnabled) {
        Feature.State state;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (state != null) {
                    SettingsManager.getInstance().setAutoScreenRecordingAudioCapturingState(state);
                    InstabugSDKLogger.d("IBG-Core", "setAutoScreenRecordingAudioCapturingEnabled: " + state.name());
                }
                InstabugSDKLogger.w("IBG-Core", "isASRAudioEnabled object passed to Instabug.setAutoScreenRecordingAudioCapturingEnabled() is null");
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.setAutoScreenRecordingAudioCapturingEnabled", voidRunnable2);
    }

    public static void show() {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                InvocationManagerContract invocationManagerContract = CoreServiceLocator.getInvocationManagerContract();
                if (invocationManagerContract != null) {
                    invocationManagerContract.show();
                }
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.show", voidRunnable2);
    }

    public static void addPrivateViews(View ... views) {
        View[] viewArray;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (Instabug.getInstance() != null && Instabug.getInstance().delegate != null) {
                    Instabug.getInstance().delegate.a(viewArray);
                }
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.addPrivateViews", voidRunnable2);
    }

    public static void removePrivateViews(View ... views) {
        View[] viewArray;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (Instabug.getInstance() != null && Instabug.getInstance().delegate != null) {
                    Instabug.getInstance().delegate.b(viewArray);
                }
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.removePrivateViews", voidRunnable2);
    }

    public static void removeAllPrivateViews() {
        APIChecker.checkAndRunInExecutor("Instabug.removeAllPrivateViews", () -> {
            Object object = Instabug.getInstance();
            if (object != null && (object = ((Instabug)object).delegate) != null) {
                ((com.instabug.library.c)object).H();
            }
        });
    }

    public static boolean isBuilding() {
        return InstabugStateProvider.getInstance().getState() == InstabugState.BUILDING;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    private static void disableInternal() {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (Instabug.getInstance() != null) {
                    Instabug.getInstance().delegate.S();
                    InstabugSDKLogger.d("IBG-Core", "disableInternal");
                }
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.disableInternal", voidRunnable2);
    }

    /*
     * WARNING - void declaration
     */
    private static void reportScreenChange(@Nullable Bitmap screenshot, @NonNull String screenName) {
        if (!Instabug.isBuilt()) {
            return;
        }
        if (Instabug.getInstance() != null && Instabug.getInstance().delegate != null) {
            void var1_1;
            Bitmap bitmap;
            Instabug.getInstance().delegate.a(bitmap, (String)var1_1);
            return;
        }
    }

    private static void reportCurrentViewChange(@NonNull String currentView) {
        if (!Instabug.isBuilt()) {
            return;
        }
        if (Instabug.getInstance() != null && Instabug.getInstance().delegate != null) {
            String string;
            Instabug.getInstance().delegate.d(string);
            return;
        }
    }

    private static void shouldDisableNativeUserStepsCapturing(boolean shouldDisable) {
        APIChecker.checkAndRunInExecutor("Instabug.shouldDisableNativeUserStepsCapturing", () -> {
            if (Instabug.getInstance() != null && Instabug.getInstance().delegate != null) {
                boolean bl;
                Instabug.getInstance().delegate.c(bl);
            }
        });
    }

    private static void setCurrentPlatform(@Platform int platform) {
        int n2;
        SettingsManager.getInstance().setCurrentPlatform(n2);
    }

    /*
     * WARNING - void declaration
     */
    private static void addUserStep(long timestamp, String stepType, String message, @Nullable String label, String viewType) {
        void var5_4;
        void var4_3;
        void var3_2;
        void var2_1;
        APIChecker.checkAndRun("addUserStep", () -> Instabug.lambda$addUserStep$16(timestamp, (String)var2_1, (String)var3_2, (String)var4_3, (String)var5_4));
    }

    @Deprecated
    public static void addExperiments(@NonNull List<String> experiments) {
        List<String> list;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                Instabug instabug = Instabug.getInstance();
                if (instabug != null) {
                    instabug.delegate.a(list);
                }
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.addExperiments", voidRunnable2);
    }

    @Deprecated
    public static void removeExperiments(@NonNull List<String> experiments) {
        List<String> list;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                Instabug instabug = Instabug.getInstance();
                if (instabug != null) {
                    instabug.delegate.c(list);
                }
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.removeExperiments", voidRunnable2);
    }

    @Deprecated
    public static void clearAllExperiments() {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                Instabug instabug = Instabug.getInstance();
                if (instabug != null) {
                    instabug.delegate.d();
                }
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.clearAllExperiments", voidRunnable2);
    }

    @Deprecated
    @RequiresApi(value=18)
    public static void setVideoEncoderConfig(@NonNull VideoEncoderConfig config) {
        Class<?> clazz = Class.forName("com.instabug.bug.settings.BugSettings");
        Class<?> clazz2 = clazz;
        Method method = clazz.getDeclaredMethod("getInstance", null);
        Object object = method.invoke(null, null);
        try {
            VideoEncoderConfig videoEncoderConfig;
            clazz2.getDeclaredMethod("setVideoEncoderConfig", VideoEncoderConfig.class).invoke(object, videoEncoderConfig);
        }
        catch (Exception exception) {
            InstabugSDKLogger.e("IBG-Core", REFLECTION_ERROR_MESSAGE + exception.getMessage());
        }
    }

    public static void setScreenshotProvider(@NonNull Callable<Bitmap> provider) {
        APIChecker.checkAndRunInExecutor("Instabug.setScreenshotProvider", () -> {
            IllegalStateException illegalStateException;
            if (SettingsManager.getInstance().getCurrentPlatform() == 2) {
                IllegalStateException illegalStateException2;
                illegalStateException = illegalStateException2;
                illegalStateException2 = new IllegalStateException("setScreenshotProvider should not be called from the native Android SDK");
                InstabugSDKLogger.e("IBG-Core", "IllegalState in Instabug.setScreenshotProvider", illegalStateException);
                return;
            }
            c.a((Callable)((Object)illegalStateException));
        });
    }

    private static void startSession() {
        APIChecker.checkAndRunInExecutor("Instabug.startSessionManually", com.instabug.library.sessioncontroller.a::e);
    }

    private static void stopSession() {
        APIChecker.checkAndRunInExecutor("Instabug.stopSessionManually", com.instabug.library.sessioncontroller.a::f);
    }

    public static void setAutoMaskScreenshotsTypes(int ... types) {
        APIChecker.checkAndRunInExecutor("Instabug.setAutoMaskScreenshotsTypes", () -> {
            int[] nArray;
            CoreServiceLocator.getUserMaskingFilterProvider().a(nArray);
        });
    }

    public static void setFullscreen(boolean isFullscreen) {
        APIChecker.checkAndRunInExecutor("Instabug.setFullscreen", () -> {
            Instabug instabug = Instabug.getInstance();
            if (instabug != null) {
                boolean bl;
                instabug.delegate.b(bl);
            }
        });
    }

    public static void willRedirectToStore() {
        APIChecker.checkAndRunInExecutor("Instabug.willRedirectToStore", () -> Instabug.lambda$willRedirectToStore$20(TimeUtils.currentTimeMillis()));
    }

    public static void setCodePushVersion(@Nullable String codePushVersion) {
        APIChecker.checkAndRunInExecutor("Instabug.setCodePushVersion", () -> {
            d.a(codePushVersion, true);
            com.instabug.library.firstseen.a.a().a(true);
            IBGCoreEventPublisher.post(IBGSdkCoreEvent.CodePushVersionChanged.INSTANCE);
        });
    }

    public static void setTheme(@Nullable IBGTheme theme) {
        APIChecker.checkAndRunInExecutor("Instabug.setTheme", () -> {
            IBGTheme iBGTheme;
            SettingsManager.getInstance().setIBGTheme(iBGTheme);
        });
    }

    public static void setNetworkAutoMaskingState(Feature.State state) {
        APIChecker.checkAndRunInExecutor("Instabug.setNetworkAutoMaskingState", () -> {
            Instabug instabug = Instabug.getInstance();
            if (instabug != null) {
                Feature.State state2;
                instabug.delegate.a(state2);
            }
        });
    }

    public static void setNetworkLogBodyEnabled(boolean shouldEnableBody) {
        boolean bl;
        NetworkInterceptionServiceLocator.getConfigurationProvider().setNetworkLogBodyEnabledBySDK(bl);
    }

    public static void setAppVariant(@Nullable String appVariant) {
        APIChecker.checkAndRunInExecutor("Instabug.setAppVariant", () -> {
            if (Instabug.isBuilt() && Instabug.isEnabled()) {
                InstabugSDKLogger.w("IBG-Core", "The AppVariant API is called after SDK initialization which is not recommended");
            }
        });
        String string = b.a(appVariant);
        if (string != null) {
            SettingsManager.getInstance().setAppVariant(string);
        }
    }

    private static void updateAndBroadcastReproConfigurations(ReproConfigurations reproConfigurations) {
        ReproConfigurations reproConfigurations2;
        SettingsManager settingsManager = SettingsManager.getInstance();
        if (settingsManager != null) {
            settingsManager.setReproConfigurations(reproConfigurations2);
        }
        IBGCoreEventPublisher.post(new IBGSdkCoreEvent.ReproState(reproConfigurations2.getModesMap()));
    }

    public static void addFeatureFlag(IBGFeatureFlag featureFlag) {
        APIChecker.checkAndRunInExecutor("Instabug.addFeaturesFlag", () -> {
            if (Instabug.getInstance() != null) {
                IBGFeatureFlag iBGFeatureFlag;
                Instabug.getInstance().delegate.a(iBGFeatureFlag);
            }
        });
    }

    public static void addFeatureFlags(List<IBGFeatureFlag> featureFlagsList) {
        APIChecker.checkAndRunInExecutor("Instabug.addFeaturesFlags", () -> {
            if (Instabug.getInstance() != null) {
                List list;
                Instabug.getInstance().delegate.b(list);
            }
        });
    }

    public static void removeFeatureFlag(List<String> keys) {
        APIChecker.checkAndRunInExecutor("Instabug.removeFeatureFlag", () -> {
            if (Instabug.getInstance() != null) {
                List list;
                Instabug.getInstance().delegate.d(list);
            }
        });
    }

    public static void removeAllFeatureFlags() {
        APIChecker.checkAndRunInExecutor("Instabug.removeAllFeatureFlags", () -> {
            if (Instabug.getInstance() != null) {
                Instabug.getInstance().delegate.G();
            }
        });
    }

    public static void removeFeatureFlag(String key) {
        APIChecker.checkAndRunInExecutor("Instabug.removeFeatureFlag", () -> {
            if (Instabug.getInstance() != null) {
                String string;
                Instabug.getInstance().delegate.b(string);
            }
        });
    }

    public static void shouldCaptureDialogs(boolean shouldCapture) {
        APIChecker.checkAndRunInExecutor("Instabug.shouldCaptureDialogs", () -> {
            boolean bl;
            SettingsManager.getInstance().setShouldCaptureDialog(bl);
        });
    }

    public static void shouldCaptureSurfaceView(boolean shouldCapture) {
        boolean bl;
        SettingsManager.getInstance().setShouldCaptureSurfaceView(bl);
    }

    public static void captureScreenshot() {
        APIChecker.checkAndRunInExecutor("Instabug.captureScreenshot", () -> {
            Instabug instabug = Instabug.getInstance();
            if (instabug != null) {
                instabug.delegate.b();
            }
        });
    }

    private static /* synthetic */ void lambda$willRedirectToStore$20(long currentTime) throws Exception {
        long l2;
        a.j().a(l2);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$addUserStep$16(long timestamp, String stepType, String message, String label, String viewType) throws Exception {
        if (Instabug.getInstance() != null && Instabug.getInstance().delegate != null) {
            void var5_4;
            void var4_3;
            void var3_2;
            void var2_1;
            long l2;
            Instabug.getInstance().delegate.a(l2, (String)var2_1, (String)var3_2, (String)var4_3, (String)var5_4);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$setCustomBrandingImage$13(Bitmap lightLogoVariant, Bitmap darkLogoVariant) throws Exception {
        void var1_1;
        Bitmap bitmap;
        SettingsManager.getInstance().setLightCustomBrandingLogo(bitmap);
        SettingsManager.getInstance().setDarkCustomBrandingLogo((Bitmap)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$setCustomBrandingImage$12(int lightLogoVariant, int darkLogoVariant) throws Exception {
        void var1_1;
        int n2;
        Instabug.setCustomBrandingImage(BitmapUtils.drawableToBitmap(ContextCompat.getDrawable((Context)appContext, (int)n2)), BitmapUtils.drawableToBitmap(ContextCompat.getDrawable((Context)appContext, (int)var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$identifyUser$6(String userName, String email, String id2) throws Exception {
        void var2_2;
        void var1_1;
        e.a(userName, (String)var1_1, (String)var2_2);
    }

    private static /* synthetic */ void lambda$identifyUser$5(String username, String email) throws Exception {
        String string;
        String string2;
        String string3 = username;
        e.a(string3, string2, null, false);
        string = string3 != null && !string.isEmpty() ? "non-empty-username" : "empty_username";
        string2 = string2 != null && !string2.isEmpty() ? "non-empty-email" : "empty-email";
        InstabugSDKLogger.i("IBG-Core", "identifyUser username: " + string + " email: " + string2);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$getUserUUID$3(OnUserUUIDReadyCallback callback, String uuid) {
        try {
            void var1_2;
            callback.onUserUUIDReady((String)var1_2);
        }
        catch (Exception exception) {
            InstabugSDKLogger.e("IBG-Core", "Something went wrong while calling OnUserUUIDReadyCallback.onUserUUIDReady", exception);
        }
    }

    public static class Builder {
        private static volatile boolean isBuildCalled = false;
        private String applicationToken;
        private Context applicationContext;
        @Nullable
        private Application application;
        private int instabugStatusBarColor;
        private InstabugInvocationEvent[] instabugInvocationEvents;
        private Feature.State userDataState;
        private Feature.State consoleLogState;
        private Feature.State instabugLogState;
        private Feature.State inAppMessagingState;
        private Feature.State pushNotificationState;
        private Feature.State trackingUserStepsState;
        private Feature.State viewHierarchyState;
        private Feature.State surveysState;
        private Feature.State userEventsState;
        private Feature.State anrDefaultState;
        private boolean emailFieldRequired;
        private boolean emailFieldVisibility;
        private boolean commentFieldRequired;
        private boolean introMessageEnabled;
        private boolean shouldPlaySounds;
        private boolean successDialogEnabled;
        private int floatingButtonOffsetFromTop;
        private boolean isSurveysAutoShowing;
        private boolean chatPromptOptionEnable;
        private boolean bugPromptOptionEnable;
        private boolean feedbackPromptOptionEnable;
        private List<Integer> deprecatedMethodsToBeLogedAfterBuild;
        private ReproConfigurations reproConfigurations;
        @Nullable
        private String appVariant;
        @MaskingType
        private int[] maskingTypes;
        @Nullable
        private String codePushVersion;
        private boolean isCodePushVersionSetByUser;
        @Nullable
        private IBGTheme theme;

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull Application application, @NonNull String applicationToken) {
            void var2_2;
            void var1_1;
            InstabugInvocationEvent[] instabugInvocationEventArray = this_;
            InstabugInvocationEvent[] instabugInvocationEventArray2 = new InstabugInvocationEvent[1];
            InstabugInvocationEvent[] this_ = instabugInvocationEventArray2;
            instabugInvocationEventArray2[0] = InstabugInvocationEvent.SHAKE;
            super((Application)var1_1, (String)var2_2, this_);
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull Application application, @NonNull String applicationToken, InstabugInvocationEvent ... instabugInvocationEvent) {
            void var1_1;
            void var2_2;
            void var3_3;
            ArrayList arrayList;
            Object object;
            this.instabugStatusBarColor = -3815737;
            this.userDataState = object = com.instabug.library.d.f;
            this.consoleLogState = object;
            this.instabugLogState = object;
            this.inAppMessagingState = object;
            this.pushNotificationState = object;
            this.trackingUserStepsState = object;
            this.viewHierarchyState = Feature.State.DISABLED;
            this.surveysState = object;
            this.userEventsState = object;
            this.anrDefaultState = object;
            this.emailFieldRequired = true;
            this.emailFieldVisibility = true;
            this.commentFieldRequired = false;
            this.introMessageEnabled = true;
            this.shouldPlaySounds = false;
            this.successDialogEnabled = true;
            this.floatingButtonOffsetFromTop = -1;
            this.isSurveysAutoShowing = true;
            this.chatPromptOptionEnable = true;
            this.bugPromptOptionEnable = true;
            this.feedbackPromptOptionEnable = true;
            object = arrayList;
            arrayList = new ArrayList();
            this.deprecatedMethodsToBeLogedAfterBuild = object;
            this.appVariant = null;
            this.maskingTypes = new int[0];
            this.codePushVersion = null;
            this.isCodePushVersionSetByUser = false;
            this.theme = null;
            IBGPendingTraceHandler.setBuilderConstructorStartTime(System.currentTimeMillis());
            this.applicationContext = application.getApplicationContext();
            this.instabugInvocationEvents = var3_3;
            this.applicationToken = var2_2;
            this.application = var1_1;
            this.reproConfigurations = ReproConfigurations.a.a();
            IBGPendingTraceHandler.setBuilderConstructorEndTime(System.currentTimeMillis());
        }

        private void updateFeaturesStates() {
            Builder builder = this;
            InstabugCore.setFeatureState("USER_DATA", builder.userDataState);
            InstabugCore.setFeatureState("CONSOLE_LOGS", builder.consoleLogState);
            InstabugCore.setFeatureState("INSTABUG_LOGS", builder.instabugLogState);
            InstabugCore.setFeatureState("IN_APP_MESSAGING", builder.inAppMessagingState);
            InstabugCore.setFeatureState("PUSH_NOTIFICATION", builder.pushNotificationState);
            InstabugCore.setFeatureState("TRACK_USER_STEPS", builder.trackingUserStepsState);
            InstabugCore.setFeatureState("VIEW_HIERARCHY_V2", builder.viewHierarchyState);
            InstabugCore.setFeatureState("SURVEYS", builder.surveysState);
            InstabugCore.setFeatureState("USER_EVENTS", builder.userEventsState);
        }

        private void logDeprecatedApis() {
            Iterator<Integer> this_ = ((Builder)((Object)this_)).deprecatedMethodsToBeLogedAfterBuild.iterator();
            while (this_.hasNext()) {
                InstabugDeprecationLogger.getInstance().log((Integer)this_.next());
            }
        }

        /*
         * WARNING - void declaration
         */
        private void logFeaturesStates(Boolean isInstabugEnabled) {
            void var1_1;
            InstabugSDKLogger.v("IBG-Core", "User data feature state is set to " + (Object)((Object)this.userDataState));
            InstabugSDKLogger.v("IBG-Core", "Console log feature state is set to " + (Object)((Object)this.consoleLogState));
            InstabugSDKLogger.v("IBG-Core", "Instabug logs feature state is set to " + (Object)((Object)this.instabugLogState));
            InstabugSDKLogger.v("IBG-Core", "In-App messaging feature state is set to" + (Object)((Object)this.inAppMessagingState));
            InstabugSDKLogger.v("IBG-Core", "Push notification feature state is set to " + (Object)((Object)this.pushNotificationState));
            InstabugSDKLogger.v("IBG-Core", "Tracking user steps feature state is set to " + (Object)((Object)this.trackingUserStepsState));
            InstabugSDKLogger.v("IBG-Core", "Repro steps feature state is set to " + this.reproConfigurations.getModesMap());
            InstabugSDKLogger.v("IBG-Core", "View hierarchy feature state is set to " + (Object)((Object)this.viewHierarchyState));
            InstabugSDKLogger.v("IBG-Core", "Surveys feature state is set to " + (Object)((Object)this.surveysState));
            InstabugSDKLogger.v("IBG-Core", "User events feature state is set to " + (Object)((Object)this.userEventsState));
            InstabugSDKLogger.v("IBG-Core", "Instabug overall state is set to " + var1_1);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private /* synthetic */ void lambda$buildInBG$0(Feature.State instabugInitialState) {
            SettingsManager.getInstance().setIBGTheme(this.theme);
            InstabugApplicationProvider.init((Application)appContext.getApplicationContext());
            IBGPendingTraceHandler.setBuilderBGStartTime(System.currentTimeMillis());
            if (this.application == null) {
                return;
            }
            Object object = this.applicationToken;
            if (object != null && !object.trim().isEmpty()) {
                com.instabug.library.c c2;
                com.instabug.library.core.a.a();
                if (this.appVariant != null) {
                    SettingsManager.getInstance().setAppVariant(this.appVariant);
                }
                void v02 = c2;
                Builder builder = this;
                InstabugSDKLogger.d("IBG-Core", "Building Instabug From BG thread, thread name: " + Thread.currentThread().getName());
                d.a(builder.codePushVersion, this.isCodePushVersionSetByUser);
                c2 = com.instabug.library.c.a(builder.application);
                INSTANCE = new Instabug(c2);
                InstabugSDKLogger.initLogger(builder.applicationContext);
                object = Feature.State.ENABLED;
                boolean bl = v02 == object;
                com.instabug.library.d d2 = com.instabug.library.d.d();
                String string = "INSTABUG";
                if (!bl) {
                    object = Feature.State.DISABLED;
                }
                Builder builder2 = this;
                d2.a(string, (Feature.State)((Object)object));
                c2.a(InstabugState.BUILDING);
                builder2.logDeprecatedApis();
                SettingsManager.getInstance().setAppToken(this.applicationToken);
                CoreServiceLocator.getNetworkDiagnosticsManager().c();
                com.instabug.library.settings.c.o().a(this.instabugInvocationEvents);
                com.instabug.library.core.plugin.c.a(builder2.applicationContext);
                new com.instabug.library.settings.b(this.applicationContext).a(bl);
                h.a(SettingsManager.getInstance());
                try {
                    CoreServiceLocator.getUserMaskingFilterProvider().a(this.maskingTypes);
                    Instabug.updateAndBroadcastReproConfigurations(builder2.reproConfigurations);
                    c2.b(builder2.applicationContext);
                    object = bl ? InstabugState.ENABLED : InstabugState.DISABLED;
                    com.instabug.library.c c3 = c2;
                    c3.a((InstabugState)((Object)object));
                    c3.N();
                    this.updateFeaturesStates();
                    this.logFeaturesStates(bl);
                    InstabugSDKLogger.d("IBG-Core", "SDK Built");
                }
                catch (Exception exception) {}
                InstabugSDKLogger.e("IBG-Core", "Error while building the sdk: ", exception);
                IBGPendingTraceHandler.setBuilderBGEndTime(System.currentTimeMillis());
                return;
            }
            InstabugSDKLogger.w("IBG-Core", "Invalid application token. Abort building the SDK");
        }

        /*
         * WARNING - void declaration
         */
        public Builder setInvocationEvents(InstabugInvocationEvent ... instabugInvocationEvents) {
            void var1_1;
            this.instabugInvocationEvents = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setTheme(@Nullable IBGTheme theme) {
            void var1_1;
            this.theme = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setTrackingUserStepsState(@NonNull Feature.State state) {
            void var1_1;
            this.trackingUserStepsState = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setReproConfigurations(ReproConfigurations configurations) {
            void var1_1;
            this.reproConfigurations = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setSdkDebugLogsLevel(int level) {
            void var1_1;
            SettingsManager.getInstance().setLogLevel((int)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setConsoleLogState(@NonNull Feature.State state) {
            void var1_1;
            this.consoleLogState = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setInstabugLogState(@NonNull Feature.State state) {
            void var1_1;
            this.instabugLogState = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setUserDataState(@NonNull Feature.State state) {
            void var1_1;
            this.userDataState = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setInAppMessagingState(@NonNull Feature.State state) {
            void var1_1;
            this.inAppMessagingState = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setViewHierarchyState(@NonNull Feature.State state) {
            void var1_1;
            this.viewHierarchyState = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setUserEventsState(@NonNull Feature.State state) {
            void var1_1;
            this.userEventsState = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setAutoMaskScreenshotsTypes(int ... types) {
            void var1_1;
            this.maskingTypes = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder ignoreFlagSecure(boolean shouldBeIgnored) {
            void var1_1;
            SettingsManager.getInstance().setIgnoreFlagSecure((boolean)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setCodePushVersion(@Nullable String codePushVersion) {
            void var1_1;
            this.codePushVersion = var1_1;
            this.isCodePushVersionSetByUser = true;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setAppVariant(@Nullable String appVariant) {
            void var1_1;
            this.appVariant = b.a((String)var1_1);
            return this;
        }

        @Nullable
        public void build() {
            IBGPendingTraceHandler.setBuilderFGStartTime(System.currentTimeMillis());
            appContext = this.applicationContext;
            if (isBuildCalled) {
                InstabugSDKLogger.v("IBG-Core", "isBuildCalled true returning..");
                return;
            }
            Builder builder = this;
            isBuildCalled = true;
            InstabugCore.startVitalComponents(builder.application);
            builder.buildInBG(Feature.State.ENABLED);
            IBGPendingTraceHandler.setBuilderFGEndTime(System.currentTimeMillis());
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public void build(Feature.State instabugInitialState) {
            void var1_1;
            String string;
            IBGPendingTraceHandler.setBuilderFGStartTime(System.currentTimeMillis());
            appContext = this.applicationContext;
            if (instabugInitialState == Feature.State.DISABLED && ((string = this.applicationToken) == null || string.isEmpty())) {
                InstabugCore.startVitalComponents(this.application);
                return;
            }
            if (isBuildCalled) {
                InstabugSDKLogger.v("IBG-Core", "isBuildCalled true returning..");
                return;
            }
            isBuildCalled = true;
            InstabugCore.startVitalComponents(this.application);
            this.buildInBG((Feature.State)var1_1);
            IBGPendingTraceHandler.setBuilderFGEndTime(System.currentTimeMillis());
        }

        /*
         * WARNING - void declaration
         */
        @VisibleForTesting
        void buildInBG(Feature.State instabugInitialState) {
            void var1_1;
            PoolProvider.getApiExecutor().execute(() -> this.lambda$buildInBG$0((Feature.State)var1_1));
        }
    }
}

