package com.instabug.library.util.collections

fun Collection<String>.unique(ignoreCase: Boolean = false): Collection<String> =
    associateBy { it.takeUnless { ignoreCase } ?: it.lowercase() }.values

fun Map<String, String>.toQueryString(): String {
    val queryString = StringBuilder("")

    forEach { query ->
        queryString.append("${query.key}=${query.value}&")
    }

    return queryString.removeSuffix("&").toString()
}
