package com.instabug.library.util;

public final class URLUtil {

    /**
     * Resolved the passed url to start with "http://" if does not start with "http://" or "https://"
     * or return the url as is otherwise
     *
     * @param url the url to resolve
     * @return The resolved url or null if the original url was null
     */
    public static String resolve(String url) {
        return (url == null
                || url.startsWith("https://")
                || url.startsWith("http://")) ? url : "http://" + url;
    }
}
