package com.instabug.library.util

import androidx.annotation.VisibleForTesting
import com.instabug.library.Constants

object AppVariantHandler {
    private const val MAX_LENGTH = 30

    @VisibleForTesting
    const val APP_VARIANT_IS_EMPTY =
        "AppVariant string cannot be empty or null. Please provide a non-empty string."

    @VisibleForTesting
    const val APP_VARIANT_EXCEEDED_LIMIT =
        "AppVariant string exceeds the 30 character limit. Extra trailing characters will be trimmed."

    @JvmStatic
    fun sanitizeAppVariant(appVariant: String?): String? {
        if (appVariant.isNullOrBlank()) {
            InstabugSDKLogger.w(
                Constants.LOG_TAG,
                APP_VARIANT_IS_EMPTY
            )
            return null
        }
        val trimmedVariant = appVariant.trim()
        if (trimmedVariant.isEmpty()) {
            InstabugSDKLogger.w(
                Constants.LOG_TAG,
                APP_VARIANT_IS_EMPTY
            )
            return null
        }
        return if (trimmedVariant.length > MAX_LENGTH) {
            InstabugSDKLogger.w(
                Constants.LOG_TAG,
                APP_VARIANT_EXCEEDED_LIMIT
            )
            trimmedVariant.substring(0, MAX_LENGTH)
        } else {
            trimmedVariant
        }
    }
}
