package com.instabug.library.tracking;

import android.os.Build;
import android.view.ActionMode;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.SearchEvent;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityEvent;

import androidx.annotation.Nullable;

import com.instabug.library.util.InstabugSDKLogger;

/**
 * Created by Barakat on 09/06/2019
 */
public class InstabugWindowCallbacks implements Window.Callback {

    private Window.Callback originalWindowCallbacks;

    InstabugWindowCallbacks(Window.Callback originalWindowCallbacks) {
        this.originalWindowCallbacks = originalWindowCallbacks;
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent event) {
        try {
            return originalWindowCallbacks.dispatchKeyEvent(event);
        } catch (Exception e) {
        }
        return false;
    }

    @Override
    public boolean dispatchKeyShortcutEvent(KeyEvent event) {
        try {
            return originalWindowCallbacks.dispatchKeyShortcutEvent(event);
        } catch (Exception e) {
        }
        return false;
    }

    @Override
    public boolean dispatchTouchEvent(MotionEvent event) {
        try {
            if (originalWindowCallbacks != null) {
                boolean dispatchBoolean = originalWindowCallbacks.dispatchTouchEvent(event);
                InstabugTouchEventsHandler.handleTouchEvent(event);
                return dispatchBoolean;
            }
            InstabugTouchEventsHandler.handleTouchEvent(event);
        } catch (Exception e) {
        }
        return false;
    }

    @Override
    public boolean dispatchTrackballEvent(MotionEvent event) {
        try {
            return originalWindowCallbacks.dispatchTrackballEvent(event);
        } catch (Exception e) {
        }
        return false;
    }

    @Override
    public boolean dispatchGenericMotionEvent(MotionEvent event) {
        try {
            return originalWindowCallbacks.dispatchGenericMotionEvent(event);
        } catch (Exception e) {
        }
        return false;
    }

    @Override
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        try {
            return originalWindowCallbacks.dispatchPopulateAccessibilityEvent(event);
        } catch (Exception e) {
        }
        return false;
    }

    @Override
    @Nullable
    public View onCreatePanelView(int featureId) {
        try {
            return originalWindowCallbacks.onCreatePanelView(featureId);
        } catch (Exception e) {
        }
        return null;
    }

    @Override
    public boolean onCreatePanelMenu(int featureId, Menu menu) {
        try {
            return originalWindowCallbacks.onCreatePanelMenu(featureId, menu);
        } catch (Exception e) {
        }
        return false;
    }

    @Override
    public boolean onPreparePanel(int featureId, @Nullable View view, Menu menu) {
        try {
            return originalWindowCallbacks.onPreparePanel(featureId, view, menu);
        } catch (Exception e) {
        }
        return false;
    }

    @Override
    public boolean onMenuOpened(int featureId, Menu menu) {
        try {
            return originalWindowCallbacks.onMenuOpened(featureId, menu);
        } catch (Exception e) {
        }
        return false;
    }

    @Override
    public boolean onMenuItemSelected(int featureId, MenuItem item) {
        try {
            return originalWindowCallbacks.onMenuItemSelected(featureId, item);
        } catch (Exception e) {
        }
        return false;
    }

    @Override
    public void onWindowAttributesChanged(WindowManager.LayoutParams attrs) {
        try {
            originalWindowCallbacks.onWindowAttributesChanged(attrs);
        } catch (Exception e) {
        }
    }

    @Override
    public void onContentChanged() {
        try {
            originalWindowCallbacks.onContentChanged();
        } catch (Exception e) {
        }
    }

    @Override
    public void onWindowFocusChanged(boolean hasFocus) {
        try {
            originalWindowCallbacks.onWindowFocusChanged(hasFocus);
        } catch (Exception e) {
        }
    }

    @Override
    public void onAttachedToWindow() {
        try {
            originalWindowCallbacks.onAttachedToWindow();
        } catch (Exception e) {
        }
    }

    @Override
    public void onDetachedFromWindow() {
        try {
            originalWindowCallbacks.onDetachedFromWindow();
        } catch (Exception e) {
        }
    }

    @Override
    public void onPanelClosed(int featureId, Menu menu) {
        try {
            originalWindowCallbacks.onPanelClosed(featureId, menu);
        } catch (Exception e) {
        }
    }

    @Override
    public boolean onSearchRequested() {
        try {
            return originalWindowCallbacks.onSearchRequested();
        } catch (Exception e) {
        }
        return false;
    }

    @Override
    public boolean onSearchRequested(SearchEvent searchEvent) {
        try {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                originalWindowCallbacks.onSearchRequested(searchEvent);
            }
        } catch (Exception e) {
        }
        return false;
    }

    @Nullable
    @Override
    public ActionMode onWindowStartingActionMode(ActionMode.Callback callback) {
        try {
            return originalWindowCallbacks.onWindowStartingActionMode(callback);
        } catch (Exception e) {
        }
        return null;
    }

    @Nullable
    @Override
    public ActionMode onWindowStartingActionMode(ActionMode.Callback callback, int type) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            try {
                return originalWindowCallbacks.onWindowStartingActionMode(callback, type);
            } catch (Exception e) {
            }
        }
        return null;
    }

    @Override
    public void onActionModeStarted(ActionMode mode) {
        try {
            originalWindowCallbacks.onActionModeStarted(mode);
        } catch (Exception e) {
        }
    }

    @Override
    public void onActionModeFinished(ActionMode mode) {
        try {
            originalWindowCallbacks.onActionModeFinished(mode);
        } catch (Exception e) {
        }
    }

    @Nullable
    public Window.Callback getOriginalWindowCallbacks() {
        return originalWindowCallbacks;
    }

}