package com.instabug.library.sessionprofiler.model.timeline;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

/**
 * Created by tarek on 3/4/18.
 */

public class BatteryState extends TimelinePoint {

    private final static String KEY_PLUGGED = "plugged";

    private float value;
    private boolean plugged;

    public BatteryState(float value, boolean plugged) {
        this.value = value;
        this.plugged = plugged;
    }

    public float getValue() {
        return value;
    }

    public void setValue(float value) {
        this.value = value;
    }

    public boolean isPlugged() {
        return plugged;
    }

    public void setPlugged(boolean plugged) {
        this.plugged = plugged;
    }

    @Override
    protected JSONObject toJSONObject() throws JSONException {
        JSONObject jsonObject = getTimelinePointJSONObject(value);
        jsonObject.put(KEY_PLUGGED, plugged);
        return jsonObject;
    }

    private static BatteryState fromJSONObject(JSONObject jsonObject) throws JSONException {
        BatteryState batteryState = new BatteryState((float) jsonObject.getDouble(KEY_VALUE),
                jsonObject.getBoolean(KEY_PLUGGED));
        batteryState.setTime(jsonObject.getDouble(KEY_TIME));
        return batteryState;
    }

    static Queue<TimelinePoint> fromJSONArray(JSONArray jsonArray) throws
            JSONException {
        Queue<TimelinePoint> timelinePoints = new ConcurrentLinkedQueue<>();

        for (int i = 0; i < jsonArray.length(); i++) {
            timelinePoints.add(fromJSONObject(jsonArray.getJSONObject(i)));
        }
        return timelinePoints;
    }


}
