package com.instabug.library.sessionV3.ratingDialogDetection

import com.instabug.library.map.Mapper
import com.instabug.library.model.v3Session.RatingDialogDetection.REVIEW_KEYBOARD_DURATION_KEY
import com.instabug.library.model.v3Session.RatingDialogDetection.REVIEW_PROMPT_DURATION_KEY
import com.instabug.library.model.v3Session.RatingDialogDetection.REVIEW_PROMPT_END_TIME_KEY
import org.json.JSONException
import org.json.JSONObject

class RatingDetectionDataMapper : Mapper<RatingDialogData, String> {

    @Throws(JSONException::class)
    override fun map(from: RatingDialogData): String = JSONObject().apply {
        put(REVIEW_PROMPT_END_TIME_KEY, from.endTimeStampMicros)
        put(REVIEW_PROMPT_DURATION_KEY, from.dialogDurationMicros)
        from.keyboardDurationMicros?.let { put(REVIEW_KEYBOARD_DURATION_KEY, it) }
    }.toString()
}
