package com.instabug.library.networkv2.request

import com.instabug.library.networkv2.request.Request.Callbacks
import com.instabug.library.util.threading.SimpleCompletableFuture
import java.util.concurrent.Future

abstract class DeferredCallBack<T, K>(
    private val future: SimpleCompletableFuture<Runnable> = SimpleCompletableFuture()
):  Callbacks<T, K>, Future<Runnable> by future {

    final override fun onSucceeded(response: T) {
        future.complete(Runnable { deferredOnSucceeded(response) })
    }

    final override fun onFailed(error: K) {
        future.complete(Runnable { deferredOnFailed(error) })
    }

    fun completeIfNotCompleted(runnable: Runnable = Runnable {  }) {
        if(!isDone) future.complete(runnable)
    }

    abstract fun deferredOnSucceeded(response: T)
    abstract fun deferredOnFailed(error: K)
}