package com.instabug.library.networkinterception

import com.instabug.library.featuresflags.configs.FeatureFlagsConfigsHandler
import com.instabug.library.internal.crossplatform.CPConfigurationsProvider
import com.instabug.library.internal.sharedpreferences.corePrefFactory
import com.instabug.library.model.NetworkLog
import com.instabug.library.networkinterception.config.DEFAULT_SDK_AUTO_MASKING_KEYS
import com.instabug.library.networkinterception.config.IBGNetworkInterceptionConfigurationProvider
import com.instabug.library.networkinterception.config.NetworkInterceptionConfigurationHandler
import com.instabug.library.networkinterception.config.NetworkInterceptionConfigurationProviderImpl
import com.instabug.library.networkinterception.sanitization.AutoMaskingSanitizer
import com.instabug.library.sanitize.Sanitizer

object NetworkInterceptionServiceLocator {
    @JvmStatic
    val configurationProvider: IBGNetworkInterceptionConfigurationProvider by lazy {
        NetworkInterceptionConfigurationProviderImpl(corePrefFactory())
    }

    @JvmStatic
    fun configurationHandler(): FeatureFlagsConfigsHandler =
        NetworkInterceptionConfigurationHandler(configurationProvider, CPConfigurationsProvider)

    @JvmStatic
    fun getAutoMaskingSanitizer(): Sanitizer<NetworkLog> =
        AutoMaskingSanitizer(
            autoMaskingHeaderKeysLowerCase,
            autoMaskingQueryKeysLowerCase,
        )

    private val autoMaskingHeaderKeysLowerCase: Set<String>
        get() {
            val keysSet = mutableSetOf<String>()
            DEFAULT_SDK_AUTO_MASKING_KEYS.forEach {
                keysSet.add(it.lowercase())
            }
            configurationProvider.autoMaskingBEHeaderKeys.forEach {
                keysSet.add(it.lowercase())
            }
            return keysSet.toSet()
        }

    private val autoMaskingQueryKeysLowerCase: Set<String>
        get() {
            val keysSet = mutableSetOf<String>()
            DEFAULT_SDK_AUTO_MASKING_KEYS.forEach {
                keysSet.add(it.lowercase())
            }
            configurationProvider.autoMaskingBEQueryKeys.forEach {
                keysSet.add(it.lowercase())
            }
            return keysSet
        }
}
