package com.instabug.library.model.v3Session

import com.instabug.library.model.common.Extractable
import com.instabug.library.sessionV3.providers.SessionAppDataProvider

data class SessionAppData(
    val appToken: String?,
    val os: String,
    val device: String,
    val appVersion: String?,
    val sdkVersion: String?,
    val locale: String?,
    val screenSize: String?
) : Extractable {

    override fun extractFields(map: MutableMap<String, Any>): MutableMap<String, Any> =
        map.apply {
            put(AppDataKeys.OS_KEY, os)
            put(AppDataKeys.DEVICE_KEY, device)
            appVersion?.let { put(AppDataKeys.APP_VERSION_KEY, appVersion) }
            sdkVersion?.let { put(AppDataKeys.SDK_VERSION_KEY, sdkVersion) }
            appToken?.let { put(AppDataKeys.APP_TOKEN_KEY, appToken) }
            locale?.let { put(AppDataKeys.LOCALE_KEY, locale) }
            screenSize?.let { put(AppDataKeys.SCREEN_SIZE_KEY, screenSize) }
        }

    companion object Factory {
        fun create(dataProvider: SessionAppDataProvider): SessionAppData =
            with(dataProvider) {
                SessionAppData(
                    os = os,
                    appVersion = appVersion,
                    device = device,
                    appToken = appToken,
                    sdkVersion = sdkVersion,
                    locale = locale,
                    screenSize = screenSize
                )
            }

    }
}